/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.common;

import java.util.Optional;
import org.opennms.netmgt.telemetry.config.api.QueueDefinition;
import org.opennms.netmgt.telemetry.distributed.common.PropertyTree;

public class MapBasedQueueDef
implements QueueDefinition {
    private final String name;
    private final Optional<Integer> threads;
    private final Optional<Integer> queueSize;
    private final Optional<Integer> batchSize;
    private final Optional<Integer> batchInterval;
    private final Optional<Boolean> useRoutingKey;

    public MapBasedQueueDef(PropertyTree definition) {
        this.name = definition.getRequiredString("name");
        this.threads = definition.getOptionalInteger("queue", "threads");
        this.queueSize = definition.getOptionalInteger("queue", "size");
        this.batchSize = definition.getOptionalInteger("batch", "size");
        this.batchInterval = definition.getOptionalInteger("batch", "interval");
        this.useRoutingKey = definition.getOptionalBoolean("queue", "use-routing-key");
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getNumThreads() {
        return this.threads;
    }

    public Optional<Integer> getBatchSize() {
        return this.batchSize;
    }

    public Optional<Integer> getBatchIntervalMs() {
        return this.batchInterval;
    }

    public Optional<Integer> getQueueSize() {
        return this.queueSize;
    }

    public Optional<Boolean> getUseRoutingKey() {
        return this.useRoutingKey;
    }
}

