/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FieldSpecifier;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.OptionsTemplateRecordHeader;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Record;

public final class OptionsTemplateRecord
implements Record {
    public final OptionsTemplateRecordHeader header;
    public final List<FieldSpecifier> scopes;
    public final List<FieldSpecifier> fields;

    public OptionsTemplateRecord(InformationElementDatabase informationElementDatabase, OptionsTemplateRecordHeader header, ByteBuf buffer) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        LinkedList<FieldSpecifier> scopes = new LinkedList<FieldSpecifier>();
        for (int i = 0; i < this.header.scopeFieldCount; ++i) {
            FieldSpecifier scopeField = new FieldSpecifier(informationElementDatabase, buffer);
            scopes.add(scopeField);
        }
        LinkedList<FieldSpecifier> fields = new LinkedList<FieldSpecifier>();
        for (int i = this.header.scopeFieldCount; i < this.header.fieldCount; ++i) {
            FieldSpecifier field = new FieldSpecifier(informationElementDatabase, buffer);
            fields.add(field);
        }
        this.scopes = Collections.unmodifiableList(scopes);
        this.fields = Collections.unmodifiableList(fields);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("scopes", this.scopes).add("fields", this.fields).toString();
    }
}

