/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.BooleanValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.DateTimeValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.FloatValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv4AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv6AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.ListValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.MacAddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.NullValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.OctetArrayValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.SignedValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.StringValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UndeclaredValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UnsignedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(RecordEnricher.class);
    private final DnsResolver dnsResolver;
    private boolean dnsLookupsEnabled;

    public RecordEnricher(DnsResolver dnsResolver, boolean dnsLookupsEnabled) {
        this.dnsResolver = Objects.requireNonNull(dnsResolver);
        this.dnsLookupsEnabled = dnsLookupsEnabled;
    }

    public CompletableFuture<RecordEnrichment> enrich(Iterable<Value<?>> record) {
        if (!this.dnsLookupsEnabled) {
            CompletableFuture<RecordEnrichment> emptyFuture = new CompletableFuture<RecordEnrichment>();
            DefaultRecordEnrichment emptyEnrichment = new DefaultRecordEnrichment(Collections.emptyMap());
            emptyFuture.complete(emptyEnrichment);
            return emptyFuture;
        }
        IpAddressCapturingVisitor ipAddressCapturingVisitor = new IpAddressCapturingVisitor();
        for (Value<?> value : record) {
            value.visit(ipAddressCapturingVisitor);
        }
        Set<InetAddress> addressesToReverseLookup = ipAddressCapturingVisitor.getAddresses();
        HashMap hostnamesByAddress = new HashMap(addressesToReverseLookup.size());
        CompletableFuture[] reverseLookupFutures = (CompletableFuture[])addressesToReverseLookup.stream().map(addr -> {
            LOG.trace("Issuing reverse lookup for: {}", addr);
            return this.dnsResolver.reverseLookup(addr).whenComplete((hostname, ex) -> {
                if (ex == null) {
                    LOG.trace("Got reverse lookup answer for '{}': {}", addr, hostname);
                    Map map = hostnamesByAddress;
                    synchronized (map) {
                        hostnamesByAddress.put(addr, hostname.orElse(null));
                    }
                }
                LOG.trace("Reverse lookup failed for '{}': {}", addr, ex);
                Map map = hostnamesByAddress;
                synchronized (map) {
                    hostnamesByAddress.put(addr, null);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Other lookups pending: {}", (Object)Sets.difference((Set)addressesToReverseLookup, hostnamesByAddress.keySet()));
                }
            });
        }).toArray(CompletableFuture[]::new);
        CompletableFuture<RecordEnrichment> future = new CompletableFuture<RecordEnrichment>();
        CompletableFuture.allOf(reverseLookupFutures).whenComplete((any, ex) -> {
            LOG.trace("All reverse lookups complete. Queries: {} Results: {}", (Object)addressesToReverseLookup, (Object)hostnamesByAddress);
            DefaultRecordEnrichment enrichment = new DefaultRecordEnrichment(hostnamesByAddress);
            future.complete(enrichment);
        });
        return future;
    }

    private static class DefaultRecordEnrichment
    implements RecordEnrichment {
        private final Map<InetAddress, String> hostnamesByAddress;

        DefaultRecordEnrichment(Map<InetAddress, String> hostnamesByAddress) {
            this.hostnamesByAddress = hostnamesByAddress;
        }

        @Override
        public Optional<String> getHostnameFor(InetAddress address) {
            return Optional.ofNullable(this.hostnamesByAddress.get(address));
        }
    }

    private static class IpAddressCapturingVisitor
    implements Value.Visitor {
        private final Set<InetAddress> addresses = new HashSet<InetAddress>();

        private IpAddressCapturingVisitor() {
        }

        public Set<InetAddress> getAddresses() {
            return this.addresses;
        }

        @Override
        public void accept(IPv4AddressValue value) {
            this.addresses.add(value.getValue());
        }

        @Override
        public void accept(IPv6AddressValue value) {
            this.addresses.add(value.getValue());
        }

        @Override
        public void accept(NullValue value) {
        }

        @Override
        public void accept(BooleanValue value) {
        }

        @Override
        public void accept(DateTimeValue value) {
        }

        @Override
        public void accept(FloatValue value) {
        }

        @Override
        public void accept(MacAddressValue value) {
        }

        @Override
        public void accept(OctetArrayValue value) {
        }

        @Override
        public void accept(SignedValue value) {
        }

        @Override
        public void accept(StringValue value) {
        }

        @Override
        public void accept(UnsignedValue value) {
        }

        @Override
        public void accept(ListValue value) {
        }

        @Override
        public void accept(UndeclaredValue value) {
        }
    }
}

