/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.graphite.adapter;

import java.time.Instant;
import java.util.Objects;

public class GraphiteMetric {
    private String path;
    private String value;
    private long timestamp;

    public GraphiteMetric(String path, String value, long timestamp) {
        this.path = Objects.requireNonNull(path);
        this.value = Objects.requireNonNull(value);
        this.timestamp = timestamp;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public Integer intValue() {
        return Integer.valueOf(this.value, 10);
    }

    public Long longValue() {
        return Long.valueOf(this.value, 10);
    }

    public Float floatValue() {
        return Float.valueOf(this.value);
    }

    public Double doubleValue() {
        return Double.valueOf(this.value);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.timestamp);
    }

    public String toString() {
        return "GraphiteMetric [path=" + this.path + ", value=" + this.value + ", timestamp=" + this.timestamp + "]";
    }

    public int hashCode() {
        return Objects.hash(this.path, this.timestamp, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphiteMetric)) {
            return false;
        }
        GraphiteMetric other = (GraphiteMetric)obj;
        return Objects.equals(this.path, other.path) && Objects.equals(this.value, other.value) && this.timestamp == other.timestamp;
    }
}

