/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.algorithms.shortestpath.BFSDistanceLabeler;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.HashMap;
import java.util.Map;

public class UnweightedShortestPath<V, E>
implements ShortestPath<V, E>,
Distance<V> {
    private Map<V, Map<V, Number>> mDistanceMap;
    private Map<V, Map<V, E>> mIncomingEdgeMap;
    private Hypergraph<V, E> mGraph;
    private Map<V, Number> distances = new HashMap<V, Number>();

    public UnweightedShortestPath(Hypergraph<V, E> g) {
        this.mDistanceMap = new HashMap<V, Map<V, Number>>();
        this.mIncomingEdgeMap = new HashMap<V, Map<V, E>>();
        this.mGraph = g;
    }

    @Override
    public Number getDistance(V source, V target) {
        Map<V, Number> sourceSPMap = this.getDistanceMap(source);
        return sourceSPMap.get(target);
    }

    @Override
    public Map<V, Number> getDistanceMap(V source) {
        Map<V, Number> sourceSPMap = this.mDistanceMap.get(source);
        if (sourceSPMap == null) {
            this.computeShortestPathsFromSource(source);
            sourceSPMap = this.mDistanceMap.get(source);
        }
        return sourceSPMap;
    }

    @Override
    public Map<V, E> getIncomingEdgeMap(V source) {
        Map<V, E> sourceIEMap = this.mIncomingEdgeMap.get(source);
        if (sourceIEMap == null) {
            this.computeShortestPathsFromSource(source);
            sourceIEMap = this.mIncomingEdgeMap.get(source);
        }
        return sourceIEMap;
    }

    private void computeShortestPathsFromSource(V source) {
        BFSDistanceLabeler<V, E> labeler = new BFSDistanceLabeler<V, E>();
        labeler.labelDistances(this.mGraph, source);
        this.distances = labeler.getDistanceDecorator();
        HashMap<V, Number> currentSourceSPMap = new HashMap<V, Number>();
        HashMap<V, E> currentSourceEdgeMap = new HashMap<V, E>();
        for (V vertex : this.mGraph.getVertices()) {
            Number distanceVal = this.distances.get(vertex);
            if (distanceVal == null || distanceVal.intValue() < 0) continue;
            currentSourceSPMap.put(vertex, distanceVal);
            int minDistance = distanceVal.intValue();
            for (E incomingEdge : this.mGraph.getInEdges(vertex)) {
                for (V neighbor : this.mGraph.getIncidentVertices(incomingEdge)) {
                    Number predDistanceVal;
                    int pred_distance;
                    if (neighbor.equals(vertex) || (pred_distance = (predDistanceVal = this.distances.get(neighbor)).intValue()) >= minDistance || pred_distance < 0) continue;
                    minDistance = predDistanceVal.intValue();
                    currentSourceEdgeMap.put(vertex, incomingEdge);
                }
            }
        }
        this.mDistanceMap.put(source, currentSourceSPMap);
        this.mIncomingEdgeMap.put(source, currentSourceEdgeMap);
    }

    public void reset() {
        this.mDistanceMap.clear();
        this.mIncomingEdgeMap.clear();
    }

    public void reset(V v) {
        this.mDistanceMap.remove(v);
        this.mIncomingEdgeMap.remove(v);
    }
}

