/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.collection;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.features.kafka.producer.NoOpProducer;
import org.opennms.features.kafka.producer.collection.CollectionSetMapper;
import org.opennms.features.kafka.producer.collection.KafkaPersister;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.rrd.RrdRepository;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersisterFactory
implements PersisterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPersisterFactory.class);
    private CollectionSetMapper collectionSetMapper;
    private Producer<String, byte[]> producer;
    private ConfigurationAdmin configAdmin;
    private String topicName;
    private boolean disableMetricsSplitting = false;

    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        return this.createPersister(params, repository);
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        KafkaPersister persister = new KafkaPersister(params);
        persister.setCollectionSetMapper(this.collectionSetMapper);
        persister.setProducer(this.producer);
        persister.setTopicName(this.topicName);
        persister.setDisableMetricsSplitting(this.disableMetricsSplitting);
        return persister;
    }

    public void init() throws IOException {
        String metricsPid = "org.opennms.features.kafka.producer.client.metrics";
        String globalPid = "org.opennms.features.kafka.producer.client";
        Properties producerConfig = new Properties();
        Dictionary properties = this.configAdmin.getConfiguration(metricsPid).getProperties();
        if (this.hasValidConfiguration(properties)) {
            LOG.info("Using metrics-specific Kafka configuration");
        } else {
            LOG.debug("Metrics-specific config not valid, falling back to global");
            properties = this.configAdmin.getConfiguration(globalPid).getProperties();
        }
        if (this.hasValidConfiguration(properties)) {
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                producerConfig.put(key, properties.get(key));
            }
            producerConfig.put("key.serializer", StringSerializer.class.getCanonicalName());
            producerConfig.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
            this.producer = (Producer)Utils.runWithGivenClassLoader(() -> new KafkaProducer(producerConfig), (ClassLoader)KafkaProducer.class.getClassLoader());
            LOG.info(" kafka producer initialized with {} ", (Object)producerConfig);
        } else {
            this.producer = new NoOpProducer<String, byte[]>();
            LOG.warn("No Kafka configuration found for metrics. Using NoOpProducer.");
        }
    }

    private boolean hasValidConfiguration(Dictionary<String, Object> properties) {
        return properties != null && !properties.isEmpty() && properties.get("bootstrap.servers") != null;
    }

    public void destroy() {
        if (this.producer != null) {
            LOG.info(" close kafka producer");
            this.producer.close();
            this.producer = null;
        }
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setCollectionSetMapper(CollectionSetMapper collectionSetMapper) {
        this.collectionSetMapper = collectionSetMapper;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setDisableMetricsSplitting(boolean disableMetricsSplitting) {
        this.disableMetricsSplitting = disableMetricsSplitting;
    }
}

