/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.persistence;

import com.google.common.base.Strings;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import java.time.Instant;
import java.util.Optional;
import org.opennms.integration.api.v1.flows.Flow;
import org.opennms.netmgt.flows.persistence.model.Direction;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;
import org.opennms.netmgt.flows.persistence.model.Locality;
import org.opennms.netmgt.flows.persistence.model.NetflowVersion;
import org.opennms.netmgt.flows.persistence.model.NodeInfo;
import org.opennms.netmgt.flows.persistence.model.SamplingAlgorithm;

public class FlowDocumentBuilder {
    public static FlowDocument buildFlowDocument(Flow enrichedFlow) {
        FlowDocument.Builder builder = FlowDocument.newBuilder();
        builder.setTimestamp(enrichedFlow.getTimestamp() != null ? enrichedFlow.getTimestamp().toEpochMilli() : 0L);
        builder.setDirection(FlowDocumentBuilder.fromDirection(enrichedFlow.getDirection()));
        FlowDocumentBuilder.getUInt64Value(enrichedFlow.getDstAs()).ifPresent(builder::setDstAs);
        FlowDocumentBuilder.getString(enrichedFlow.getDstAddr()).ifPresent(builder::setDstAddress);
        enrichedFlow.getDstAddrHostname().ifPresent(builder::setDstHostname);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getDstMaskLen()).ifPresent(builder::setDstMaskLen);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getDstPort()).ifPresent(builder::setDstPort);
        FlowDocumentBuilder.getString(enrichedFlow.getSrcAddr()).ifPresent(builder::setSrcAddress);
        enrichedFlow.getSrcAddrHostname().ifPresent(builder::setSrcHostname);
        FlowDocumentBuilder.getUInt64Value(enrichedFlow.getSrcAs()).ifPresent(builder::setSrcAs);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getSrcMaskLen()).ifPresent(builder::setSrcMaskLen);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getSrcPort()).ifPresent(builder::setSrcPort);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getEngineId()).ifPresent(builder::setEngineId);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getEngineType()).ifPresent(builder::setEngineType);
        FlowDocumentBuilder.getUInt64Value(enrichedFlow.getBytes()).ifPresent(builder::setNumBytes);
        FlowDocumentBuilder.getUInt64Value(enrichedFlow.getPackets()).ifPresent(builder::setNumPackets);
        FlowDocumentBuilder.getUInt64Value(enrichedFlow.getDeltaSwitched()).ifPresent(builder::setDeltaSwitched);
        FlowDocumentBuilder.getUInt64Value(enrichedFlow.getFirstSwitched()).ifPresent(builder::setFirstSwitched);
        FlowDocumentBuilder.getUInt64Value(enrichedFlow.getLastSwitched()).ifPresent(builder::setLastSwitched);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getInputSnmp()).ifPresent(builder::setInputSnmpIfindex);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getOutputSnmp()).ifPresent(builder::setOutputSnmpIfindex);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getIpProtocolVersion()).ifPresent(builder::setIpProtocolVersion);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getProtocol()).ifPresent(builder::setProtocol);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getTcpFlags()).ifPresent(builder::setTcpFlags);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getTos()).ifPresent(builder::setTos);
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getDscp()).ifPresent(dscp -> builder.setDscp((UInt32Value)dscp));
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getEcn()).ifPresent(ecn -> builder.setEcn((UInt32Value)ecn));
        FlowDocumentBuilder.getUInt32Value(enrichedFlow.getFlowRecords()).ifPresent(builder::setNumFlowRecords);
        FlowDocumentBuilder.getUInt64Value(enrichedFlow.getFlowSeqNum()).ifPresent(builder::setFlowSeqNum);
        String vlan = enrichedFlow.getVlan() != null ? Integer.toUnsignedString(enrichedFlow.getVlan()) : null;
        FlowDocumentBuilder.getString(vlan).ifPresent(builder::setVlan);
        FlowDocumentBuilder.getString(enrichedFlow.getNextHop()).ifPresent(builder::setNextHopAddress);
        enrichedFlow.getNextHopHostname().ifPresent(builder::setNextHopHostname);
        builder.setSamplingAlgorithm(FlowDocumentBuilder.fromSamplingAlgorithm(enrichedFlow.getSamplingAlgorithm()));
        FlowDocumentBuilder.getDoubleValue(enrichedFlow.getSamplingInterval()).ifPresent(builder::setSamplingInterval);
        NetflowVersion netflowVersion = FlowDocumentBuilder.fromNetflowVersion(enrichedFlow.getNetflowVersion());
        Optional.ofNullable(netflowVersion).ifPresent(builder::setNetflowVersion);
        FlowDocumentBuilder.getString(enrichedFlow.getApplication()).ifPresent(builder::setApplication);
        FlowDocumentBuilder.getString(enrichedFlow.getHost()).ifPresent(builder::setHost);
        FlowDocumentBuilder.getString(enrichedFlow.getLocation()).ifPresent(builder::setLocation);
        builder.setDstLocality(FlowDocumentBuilder.fromLocality(enrichedFlow.getDstLocality()));
        builder.setSrcLocality(FlowDocumentBuilder.fromLocality(enrichedFlow.getSrcLocality()));
        builder.setFlowLocality(FlowDocumentBuilder.fromLocality(enrichedFlow.getFlowLocality()));
        FlowDocumentBuilder.buildNodeInfo(enrichedFlow.getSrcNodeInfo()).ifPresent(builder::setSrcNode);
        FlowDocumentBuilder.buildNodeInfo(enrichedFlow.getExporterNodeInfo()).ifPresent(builder::setExporterNode);
        FlowDocumentBuilder.buildNodeInfo(enrichedFlow.getDstNodeInfo()).ifPresent(builder::setDestNode);
        builder.setClockCorrection(enrichedFlow.getClockCorrection() != null ? enrichedFlow.getClockCorrection().toMillis() : 0L);
        return builder.build();
    }

    private static Optional<UInt64Value> getUInt64Value(Long value) {
        if (value != null) {
            return Optional.of(UInt64Value.newBuilder().setValue(value.longValue()).build());
        }
        return Optional.empty();
    }

    private static Optional<UInt64Value> getUInt64Value(Instant value) {
        if (value != null) {
            return Optional.of(UInt64Value.newBuilder().setValue(value.toEpochMilli()).build());
        }
        return Optional.empty();
    }

    private static Optional<UInt32Value> getUInt32Value(Integer value) {
        if (value != null) {
            return Optional.of(UInt32Value.newBuilder().setValue(value.intValue()).build());
        }
        return Optional.empty();
    }

    private static Optional<DoubleValue> getDoubleValue(Double value) {
        if (value != null) {
            return Optional.of(DoubleValue.newBuilder().setValue(value.doubleValue()).build());
        }
        return Optional.empty();
    }

    private static Optional<String> getString(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static Direction fromDirection(Flow.Direction direction) {
        switch (direction) {
            case EGRESS: {
                return Direction.EGRESS;
            }
            case INGRESS: {
                return Direction.INGRESS;
            }
            case UNKNOWN: {
                return Direction.UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction.name());
    }

    private static Locality fromLocality(Flow.Locality locality) {
        if (locality == null) {
            return Locality.PUBLIC;
        }
        switch (locality) {
            case PRIVATE: {
                return Locality.PRIVATE;
            }
            case PUBLIC: {
                return Locality.PUBLIC;
            }
        }
        return Locality.PUBLIC;
    }

    private static SamplingAlgorithm fromSamplingAlgorithm(Flow.SamplingAlgorithm samplingAlgorithm) {
        if (samplingAlgorithm == null) {
            return SamplingAlgorithm.UNASSIGNED;
        }
        switch (samplingAlgorithm) {
            case SystematicCountBasedSampling: {
                return SamplingAlgorithm.SYSTEMATIC_COUNT_BASED_SAMPLING;
            }
            case SystematicTimeBasedSampling: {
                return SamplingAlgorithm.SYSTEMATIC_TIME_BASED_SAMPLING;
            }
            case RandomNOutOfNSampling: {
                return SamplingAlgorithm.RANDOM_N_OUT_OF_N_SAMPLING;
            }
            case UniformProbabilisticSampling: {
                return SamplingAlgorithm.UNIFORM_PROBABILISTIC_SAMPLING;
            }
            case PropertyMatchFiltering: {
                return SamplingAlgorithm.PROPERTY_MATCH_FILTERING;
            }
            case HashBasedFiltering: {
                return SamplingAlgorithm.HASH_BASED_FILTERING;
            }
            case FlowStateDependentIntermediateFlowSelectionProcess: {
                return SamplingAlgorithm.FLOW_STATE_DEPENDENT_INTERMEDIATE_FLOW_SELECTION_PROCESS;
            }
            case Unassigned: {
                return SamplingAlgorithm.UNASSIGNED;
            }
        }
        return SamplingAlgorithm.UNRECOGNIZED;
    }

    private static NetflowVersion fromNetflowVersion(Flow.NetflowVersion netflowVersion) {
        if (netflowVersion == null) {
            return null;
        }
        switch (netflowVersion) {
            case V5: {
                return NetflowVersion.V5;
            }
            case V9: {
                return NetflowVersion.V9;
            }
            case IPFIX: {
                return NetflowVersion.IPFIX;
            }
            case SFLOW: {
                return NetflowVersion.SFLOW;
            }
        }
        return NetflowVersion.UNRECOGNIZED;
    }

    private static Optional<NodeInfo> buildNodeInfo(Flow.NodeInfo nodeInfo) {
        if (nodeInfo != null) {
            NodeInfo.Builder builder = NodeInfo.newBuilder();
            builder.setNodeId(nodeInfo.getNodeId());
            FlowDocumentBuilder.getString(nodeInfo.getForeignId()).ifPresent(builder::setForeginId);
            FlowDocumentBuilder.getString(nodeInfo.getForeignSource()).ifPresent(builder::setForeignSource);
            nodeInfo.getCategories().forEach(builder::addCategories);
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }
}

