/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.enlinkd.service.api.Bridge;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTable;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgePortWithMacs;
import org.opennms.netmgt.enlinkd.service.api.BridgeSimpleConnection;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.BroadcastDomain;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DiscoveryBridgeTopology {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryBridgeTopology.class);
    private final Map<Integer, BridgeForwardingTable> m_bridgeFtMapUpdate = new HashMap<Integer, BridgeForwardingTable>();
    private final BroadcastDomain m_domain;
    private Set<Integer> m_failed;
    private Set<Integer> m_parsed;

    public static Set<String> getMacs(BridgeForwardingTable xBridge, BridgeForwardingTable yBridge, BridgeSimpleConnection simple) throws BridgeTopologyException {
        if (simple.getFirstPort() == null) {
            throw new BridgeTopologyException("getMacs: not found simple connection [" + xBridge.getNodeId() + "]", simple);
        }
        if (simple.getSecondPort() == null) {
            throw new BridgeTopologyException("getMacs: not found simple connection [" + yBridge.getNodeId() + "]", simple);
        }
        if (xBridge.getNodeId().intValue() != simple.getFirstPort().getNodeId().intValue()) {
            throw new BridgeTopologyException("getMacs: node mismatch [" + xBridge.getNodeId() + "] found ", simple.getFirstPort());
        }
        if (yBridge.getNodeId().intValue() != simple.getSecondPort().getNodeId().intValue()) {
            throw new BridgeTopologyException("getMacs: node mismatch [" + yBridge.getNodeId() + "]", simple.getSecondPort());
        }
        Set<String> macsOnSegment = xBridge.getBridgePortWithMacs(simple.getFirstPort()).getMacs();
        macsOnSegment.retainAll(yBridge.getBridgePortWithMacs(simple.getSecondPort()).getMacs());
        return macsOnSegment;
    }

    public static Set<BridgePortWithMacs> getThroughSet(BridgeForwardingTable bridgeFt, Set<BridgePort> excluded) throws BridgeTopologyException {
        for (BridgePort exclude : excluded) {
            if (exclude.getNodeId().intValue() == bridgeFt.getNodeId().intValue()) continue;
            throw new BridgeTopologyException("getThroughSet: node mismatch [" + bridgeFt.getNodeId() + "]", exclude);
        }
        HashSet<BridgePortWithMacs> throughSet = new HashSet<BridgePortWithMacs>();
        bridgeFt.getPorttomac().stream().filter(ptm -> !excluded.contains(ptm.getPort())).forEach(throughSet::add);
        return throughSet;
    }

    public static BridgeForwardingTable create(Bridge bridge, Set<BridgeForwardingTableEntry> entries) throws BridgeTopologyException {
        if (bridge == null) {
            throw new BridgeTopologyException("bridge must not be null");
        }
        if (entries == null) {
            throw new BridgeTopologyException("bridge forwarding table must not be null");
        }
        for (BridgeForwardingTableEntry link2 : entries) {
            if (link2.getNodeId().intValue() == bridge.getNodeId().intValue()) continue;
            throw new BridgeTopologyException("create: bridge:[" + bridge.getNodeId() + "] and forwarding table must have the same nodeid", link2);
        }
        BridgeForwardingTable bridgeFt = new BridgeForwardingTable(bridge, entries);
        entries.stream().filter(link -> link.getBridgeDot1qTpFdbStatus() == BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF).forEach(link -> {
            bridgeFt.getIdentifiers().add(link.getMacAddress());
            if (LOG.isDebugEnabled()) {
                LOG.debug("create: bridge:[{}] adding bid {}", (Object)bridge.getNodeId(), (Object)link.printTopology());
            }
        });
        for (BridgeForwardingTableEntry link3 : entries) {
            if (link3.getBridgeDot1qTpFdbStatus() != BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
            if (bridgeFt.getIdentifiers().contains(link3.getMacAddress())) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("create: bridge:[{}] skip bid {}", (Object)bridge.getNodeId(), (Object)link3.printTopology());
                continue;
            }
            BridgePort bridgeport = DiscoveryBridgeTopology.getFromBridgeForwardingTableEntry(link3);
            BridgePortWithMacs bpwm = bridgeFt.getBridgePortWithMacs(bridgeport);
            if (bpwm == null) {
                bridgeFt.getPorttomac().add(new BridgePortWithMacs(bridgeport, new HashSet<String>()));
            }
            bridgeFt.getBridgePortWithMacs(bridgeport).getMacs().add(link3.getMacAddress());
            if (bridgeFt.getMactoport().containsKey(link3.getMacAddress())) {
                bridgeFt.getDuplicated().put(link3.getMacAddress(), new HashSet());
                bridgeFt.getDuplicated().get(link3.getMacAddress()).add(bridgeport);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("create: bridge:[{}] duplicated {}", (Object)bridge.getNodeId(), (Object)link3.printTopology());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("create: bridge:[{}] adding {}", (Object)bridge.getNodeId(), (Object)link3.printTopology());
            }
            bridgeFt.getMactoport().put(link3.getMacAddress(), bridgeport);
        }
        for (String mac : bridgeFt.getDuplicated().keySet()) {
            BridgePort saved = bridgeFt.getMactoport().remove(mac);
            if (LOG.isDebugEnabled()) {
                LOG.debug("create: bridge:[{}] remove duplicated [{}] from {}", new Object[]{bridge.getNodeId(), mac, saved.printTopology()});
            }
            BridgePortWithMacs savedwithmacs = bridgeFt.getBridgePortWithMacs(saved);
            savedwithmacs.getMacs().remove(mac);
            for (BridgePort dupli : bridgeFt.getDuplicated().get(mac)) {
                BridgePortWithMacs dupliwithmacs = bridgeFt.getBridgePortWithMacs(dupli);
                dupliwithmacs.getMacs().remove(mac);
            }
            bridgeFt.getDuplicated().get(mac).add(saved);
        }
        return bridgeFt;
    }

    public static BridgePort getFromBridgeForwardingTableEntry(BridgeForwardingTableEntry link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNodeId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static Bridge create(BroadcastDomain domain, Integer nodeid) {
        Bridge bridge = new Bridge(nodeid);
        domain.getBridges().add(bridge);
        return bridge;
    }

    public static Set<BridgeForwardingTableEntry> calculateBFT(BroadcastDomain domain, Bridge bridge) throws BridgeTopologyException {
        if (domain == null) {
            throw new BridgeTopologyException("calculateBFT: domain cannot be null");
        }
        if (bridge == null) {
            throw new BridgeTopologyException("calculateBFT: bridge cannot be null", domain);
        }
        Integer bridgeId = bridge.getNodeId();
        if (bridgeId == null) {
            throw new BridgeTopologyException("calculateBFT: bridge Id cannot be null", bridge);
        }
        HashMap bft = new HashMap();
        HashMap<Integer, BridgePort> portifindexmap = new HashMap<Integer, BridgePort>();
        Map<Integer, Integer> upperForwardingBridgePorts = DiscoveryBridgeTopology.getUpperForwardingBridgePorts(domain, bridge, new HashMap<Integer, Integer>(), 0);
        HashMap<Integer, Integer> bridgeIdtobridgePortOnBridge = new HashMap<Integer, Integer>();
        for (Integer n : upperForwardingBridgePorts.keySet()) {
            bridgeIdtobridgePortOnBridge.put(n, bridge.getRootPort());
        }
        for (SharedSegment sharedSegment : domain.getSharedSegments()) {
            Integer bridgeport;
            if (sharedSegment.getBridgeIdsOnSegment().contains(bridgeId)) {
                BridgePort bport = sharedSegment.getBridgePort(bridgeId);
                portifindexmap.put(bport.getBridgePort(), bport);
                bridgeport = bport.getBridgePort();
            } else {
                bridgeport = DiscoveryBridgeTopology.getCalculateBFT(domain, sharedSegment, bridge, bridgeIdtobridgePortOnBridge, new HashSet<Integer>(), 0);
            }
            if (!bft.containsKey(bridgeport)) {
                bft.put(bridgeport, new HashSet());
            }
            ((Set)bft.get(bridgeport)).addAll(sharedSegment.getMacsOnSegment());
        }
        ArrayList<BridgePortWithMacs> links = new ArrayList<BridgePortWithMacs>(domain.getForwarders(bridgeId));
        for (Integer bridgePort : bft.keySet()) {
            links.add(new BridgePortWithMacs((BridgePort)portifindexmap.get(bridgePort), (Set)bft.get(bridgePort)));
        }
        HashSet<BridgeForwardingTableEntry> hashSet = new HashSet<BridgeForwardingTableEntry>();
        links.stream().filter(bfti -> bfti.getMacs().size() > 0).forEach(bfti -> entries.addAll(bfti.getBridgeForwardingTableEntrySet()));
        return hashSet;
    }

    public static Bridge electRootBridge(BroadcastDomain domain) throws BridgeTopologyException {
        if (domain.getBridges().size() == 1) {
            return domain.getBridges().iterator().next();
        }
        for (Bridge electable : domain.getBridges()) {
            if (electable.getDesignated() == null) continue;
            return DiscoveryBridgeTopology.getUpperBridge(domain, electable, 0);
        }
        return null;
    }

    public static Bridge getUpperBridge(BroadcastDomain domain, Bridge electableroot, int level) throws BridgeTopologyException {
        if (level == 30) {
            throw new BridgeTopologyException("getUpperBridge, too many iterations", electableroot);
        }
        for (Bridge electable : domain.getBridges()) {
            if (!electable.getIdentifiers().contains(electableroot.getDesignated())) continue;
            return DiscoveryBridgeTopology.getUpperBridge(domain, electable, ++level);
        }
        return electableroot;
    }

    public static Map<Integer, Integer> getUpperForwardingBridgePorts(BroadcastDomain domain, Bridge bridge, Map<Integer, Integer> downports, int level) throws BridgeTopologyException {
        if (level == 30) {
            throw new BridgeTopologyException("getUpperForwardingBridgePorts: too many iteration", bridge);
        }
        if (bridge.isRootBridge()) {
            return downports;
        }
        SharedSegment upSegment = domain.getSharedSegment(bridge.getNodeId(), bridge.getRootPort());
        if (upSegment == null) {
            throw new BridgeTopologyException("getUpperForwardingBridgePorts: no up segment", bridge);
        }
        Bridge upBridge = domain.getBridge(upSegment.getDesignatedBridge());
        if (upBridge == null) {
            throw new BridgeTopologyException("getUpperForwardingBridgePorts: no designated bridge on segment", bridge);
        }
        BridgePort bp = upSegment.getBridgePort(upBridge.getNodeId());
        downports.put(bp.getNodeId(), bp.getBridgePort());
        return DiscoveryBridgeTopology.getUpperForwardingBridgePorts(domain, upBridge, downports, ++level);
    }

    /*
     * WARNING - void declaration
     */
    public static Integer getCalculateBFT(BroadcastDomain domain, SharedSegment segment, Bridge bridge, Map<Integer, Integer> bridgetobridgeport, Set<Integer> downBridgeIds, int level) throws BridgeTopologyException {
        void var7_12;
        if (level == 30) {
            throw new BridgeTopologyException("getCalculateBFT: too many iteration", domain);
        }
        for (Integer n : segment.getBridgeIdsOnSegment()) {
            if (!bridgetobridgeport.containsKey(n)) continue;
            Integer bridgeport = bridgetobridgeport.get(n);
            for (Integer bridgeidonsegment : downBridgeIds) {
                bridgetobridgeport.put(bridgeidonsegment, bridgeport);
            }
            return bridgeport;
        }
        Integer upBridgeId = segment.getDesignatedBridge();
        if (upBridgeId.intValue() == bridge.getNodeId().intValue()) {
            for (Integer bridgeidonsegment : downBridgeIds) {
                bridgetobridgeport.put(bridgeidonsegment, segment.getDesignatedPort().getBridgePort());
            }
            return segment.getDesignatedPort().getBridgePort();
        }
        if (upBridgeId.intValue() == domain.getRootBridge().getNodeId().intValue()) {
            for (Integer bridgeidonsegment : downBridgeIds) {
                bridgetobridgeport.put(bridgeidonsegment, bridge.getRootPort());
            }
            return bridge.getRootPort();
        }
        downBridgeIds.addAll(segment.getBridgeIdsOnSegment());
        Object var7_10 = null;
        for (Bridge cbridge : domain.getBridges()) {
            if (cbridge.getNodeId().intValue() == bridge.getNodeId().intValue() || cbridge.getNodeId().intValue() != upBridgeId.intValue()) continue;
            Bridge bridge2 = cbridge;
            break;
        }
        if (var7_12 == null) {
            throw new BridgeTopologyException("getCalculateBFT: cannot find up bridge on domain", domain);
        }
        SharedSegment up = domain.getSharedSegment(var7_12.getNodeId(), var7_12.getRootPort());
        if (up == null) {
            throw new BridgeTopologyException("getCalculateBFT: cannot find up segment on domain", domain);
        }
        return DiscoveryBridgeTopology.getCalculateBFT(domain, up, bridge, bridgetobridgeport, downBridgeIds, ++level);
    }

    public BroadcastDomain getDomain() {
        return this.m_domain;
    }

    public Set<Integer> getFailed() {
        return this.m_failed;
    }

    public Set<Integer> getParsed() {
        return this.m_parsed;
    }

    public void addUpdatedBFT(Integer bridgeid, Set<BridgeForwardingTableEntry> notYetParsedBFT) {
        if (this.m_domain.getBridge(bridgeid) == null) {
            DiscoveryBridgeTopology.create(this.m_domain, bridgeid);
        }
        try {
            this.m_bridgeFtMapUpdate.put(bridgeid, DiscoveryBridgeTopology.create(this.m_domain.getBridge(bridgeid), notYetParsedBFT));
        }
        catch (BridgeTopologyException e) {
            LOG.warn("calculate:  node[{}], {}, topology:\n{}", new Object[]{bridgeid, e.getMessage(), e.printTopology(), e});
        }
    }

    public DiscoveryBridgeTopology(BroadcastDomain domain) {
        Assert.notNull((Object)domain);
        this.m_domain = domain;
    }

    public String getInfo() {
        StringBuilder info = new StringBuilder();
        info.append(this.getName());
        if (this.m_domain != null) {
            info.append(" domain nodes: ");
            info.append(this.m_domain.getBridgeNodesOnDomain());
        }
        info.append(", updated bft nodes: ");
        info.append(this.m_bridgeFtMapUpdate.keySet());
        if (this.m_parsed != null) {
            info.append(", parsed bft nodes: ");
            info.append(this.m_parsed);
        }
        if (this.m_failed != null) {
            info.append(", failed bft nodes: ");
            info.append(this.m_failed);
        }
        return info.toString();
    }

    public String getName() {
        return "DiscoveryBridgeTopology";
    }

    private Bridge calcRootBridge() {
        int size = 0;
        Bridge elected = null;
        for (Integer bridgeid : this.m_bridgeFtMapUpdate.keySet()) {
            Bridge bridge = this.m_domain.getBridge(bridgeid);
            LOG.debug("calculate: bridge:[{}] bft size \"{}\" in topology", (Object)bridge.getNodeId(), (Object)this.m_bridgeFtMapUpdate.get(bridgeid).getBftSize());
            if (size >= this.m_bridgeFtMapUpdate.get(bridgeid).getBftSize()) continue;
            elected = bridge;
            size = this.m_bridgeFtMapUpdate.get(bridgeid).getBftSize();
        }
        if (elected != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("calculate: bridge:[{}] 'elected' root with max bft size \"{}\" in topology", (Object)elected.getNodeId(), (Object)size);
            }
        } else {
            elected = this.m_domain.getBridges().iterator().next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("calculate: bridge:[{}] 'elected' first bridge in topology", (Object)elected.getNodeId());
            }
        }
        return elected;
    }

    private Bridge electRootBridge() throws BridgeTopologyException {
        Bridge electedRoot = DiscoveryBridgeTopology.electRootBridge(this.m_domain);
        Bridge rootBridge = this.m_domain.getRootBridge();
        if (electedRoot == null) {
            electedRoot = rootBridge != null ? rootBridge : this.calcRootBridge();
        }
        if (electedRoot.getNodeId() == null) {
            throw new BridgeTopologyException("elected Root bridge id cannot be null", electedRoot);
        }
        return electedRoot;
    }

    private void root(BridgeForwardingTable rootBft, Map<Integer, BridgeForwardingTable> bridgeFtMapCalcul) throws BridgeTopologyException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: bridge:[{}] elected has updated bft", (Object)rootBft.getNodeId());
        }
        if (this.m_domain.getSharedSegments().isEmpty()) {
            rootBft.getBridge().setRootBridge();
            rootBft.getPorttomac().forEach(this.m_domain::add);
            LOG.debug("calculate: bridge:[{}] elected [root] is first:{}", (Object)rootBft.getNodeId(), this.m_domain.getBridgeNodesOnDomain());
            return;
        }
        BridgeForwardingTable oldRootBft = bridgeFtMapCalcul.get(this.m_domain.getRootBridge().getNodeId());
        BridgeSimpleConnection sp = BridgeSimpleConnection.create(oldRootBft, rootBft);
        sp.findSimpleConnection();
        rootBft.setRootPort(sp.getSecondBridgePort());
        this.down(oldRootBft, rootBft, sp, bridgeFtMapCalcul, 0);
    }

    public void calculate() {
        BridgeForwardingTable failedBridgeFT;
        BridgeForwardingTable rootBft;
        Bridge electedRoot;
        Assert.notNull(this.m_bridgeFtMapUpdate);
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: domain\n{}", (Object)this.m_domain.printTopology());
        }
        this.m_parsed = new HashSet<Integer>();
        this.m_failed = new HashSet<Integer>();
        try {
            electedRoot = this.electRootBridge();
        }
        catch (BridgeTopologyException e) {
            LOG.error("calculate: {}, topology:\n{}", new Object[]{e.getMessage(), e.printTopology(), e});
            this.m_failed.addAll(this.m_bridgeFtMapUpdate.keySet());
            return;
        }
        HashMap<Integer, BridgeForwardingTable> bridgeFtMapCalcul = new HashMap<Integer, BridgeForwardingTable>();
        if (this.m_bridgeFtMapUpdate.keySet().equals(this.m_domain.getBridgeNodesOnDomain())) {
            this.m_domain.clearTopology();
            if (LOG.isDebugEnabled()) {
                LOG.debug("calculate: domain cleaned ->\n{}", (Object)this.m_domain.printTopology());
            }
        } else {
            for (Integer bridgeId : this.m_bridgeFtMapUpdate.keySet()) {
                if (this.m_domain.getBridge(bridgeId).isNewTopology()) {
                    LOG.debug("calculate: bridge:[{}] is 'new'. skip clean topology   ", (Object)bridgeId);
                    continue;
                }
                this.m_domain.clearTopologyForBridge(bridgeId);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("calculate: bridge:[{}] cleaned ->\n{}", (Object)bridgeId, (Object)this.m_domain.printTopology());
            }
            for (Bridge bridge : this.m_domain.getBridges()) {
                if (this.m_bridgeFtMapUpdate.containsKey(bridge.getNodeId())) continue;
                if (bridge.isNewTopology()) {
                    LOG.warn("calculate: bridge:[{}] is new without update bft", (Object)bridge.getNodeId());
                    continue;
                }
                try {
                    bridgeFtMapCalcul.put(bridge.getNodeId(), DiscoveryBridgeTopology.create(bridge, DiscoveryBridgeTopology.calculateBFT(this.m_domain, bridge)));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("calculate: bft from domain\n{}", (Object)((BridgeForwardingTable)bridgeFtMapCalcul.get(bridge.getNodeId())).printTopology());
                }
                catch (BridgeTopologyException e) {
                    LOG.warn("calculate: bridge:[{}] clear topology. no calculated bft: {} ->\n{}", new Object[]{bridge.getNodeId(), e.getMessage(), e.printTopology()});
                    this.m_domain.clearTopology();
                    this.calculate();
                }
            }
        }
        if ((rootBft = this.m_bridgeFtMapUpdate.get(electedRoot.getNodeId())) != null) {
            try {
                this.root(rootBft, bridgeFtMapCalcul);
                this.m_parsed.add(rootBft.getNodeId());
            }
            catch (BridgeTopologyException e) {
                LOG.error("calculate: bridge:[{}], {}, \n{}", new Object[]{rootBft.getNodeId(), e.getMessage(), e.printTopology()});
                this.m_failed.addAll(this.m_bridgeFtMapUpdate.keySet());
                return;
            }
        }
        if (rootBft == null) {
            rootBft = (BridgeForwardingTable)bridgeFtMapCalcul.get(electedRoot.getNodeId());
        }
        if (this.m_domain.getRootBridge() != null && !Objects.equals(this.m_domain.getRootBridge().getNodeId(), electedRoot.getNodeId())) {
            this.m_domain.hierarchySetUp(electedRoot);
            LOG.debug("calculate: bridge:[{}] elected is new [root] ->\n{}", (Object)electedRoot.getNodeId(), (Object)this.m_domain.printTopology());
        }
        HashSet<Integer> postprocessing = new HashSet<Integer>();
        for (Integer bridgeid : this.m_bridgeFtMapUpdate.keySet()) {
            if (this.m_parsed.contains(bridgeid) || this.m_failed.contains(bridgeid)) continue;
            BridgeForwardingTable bridgeFT = this.m_bridgeFtMapUpdate.get(bridgeid);
            if (bridgeFT.getPorttomac().size() == 1) {
                Integer bridgeFTrootPort = bridgeFT.getPorttomac().iterator().next().getPort().getBridgePort();
                bridgeFT.setRootPort(bridgeFTrootPort);
                postprocessing.add(bridgeid);
                LOG.debug("calculate: bridge:[{}] only one port:[{}] set to root. Postprocessing", (Object)bridgeid, (Object)bridgeFTrootPort);
                continue;
            }
            BridgeSimpleConnection upsimpleconn = BridgeSimpleConnection.create(rootBft, bridgeFT);
            try {
                upsimpleconn.findSimpleConnection();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("calculate: level: 1, bridge:[{}] -> {}", (Object)bridgeFT.getNodeId(), (Object)upsimpleconn.printTopology());
                }
                bridgeFT.setRootPort(upsimpleconn.getSecondBridgePort());
                LOG.debug("calculate: level: 1, bridge:[{}]. set root port:[{}]", (Object)bridgeFT.getNodeId(), (Object)upsimpleconn.getSecondBridgePort());
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], no root port found. {}, \n{}", new Object[]{bridgeid, e.getMessage(), e.printTopology()});
                this.m_failed.add(bridgeid);
                continue;
            }
            try {
                this.down(rootBft, this.m_bridgeFtMapUpdate.get(bridgeid), upsimpleconn, bridgeFtMapCalcul, 0);
                this.m_parsed.add(bridgeid);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], no topology found. {}, \n{}", new Object[]{bridgeid, e.getMessage(), e.printTopology()});
                this.m_failed.add(bridgeid);
            }
        }
        for (Integer failedbridgeid : new HashSet<Integer>(this.m_failed)) {
            if (failedbridgeid == null) {
                LOG.error("calculate: bridge:[null], first iteration on failed");
                continue;
            }
            failedBridgeFT = this.m_bridgeFtMapUpdate.get(failedbridgeid);
            if (failedBridgeFT == null) {
                LOG.error("calculate: bridge:[{}], first iteration on failed. FT is null", (Object)failedbridgeid);
                continue;
            }
            try {
                this.postprocess(failedBridgeFT, rootBft, bridgeFtMapCalcul, new HashSet<Integer>(this.m_parsed));
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], first iteration on failed. no topology found. {}, \n{}", new Object[]{failedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            this.m_parsed.add(failedbridgeid);
            this.m_failed.remove(failedbridgeid);
        }
        for (Integer failedbridgeid : new HashSet<Integer>(this.m_failed)) {
            if (failedbridgeid == null) {
                LOG.error("calculate: bridge:[null], second iteration on failed");
                continue;
            }
            failedBridgeFT = this.m_bridgeFtMapUpdate.get(failedbridgeid);
            if (failedBridgeFT == null) {
                LOG.error("calculate: bridge:[{}], second iteration on failed. FT is null", (Object)failedbridgeid);
                continue;
            }
            try {
                this.postprocess(failedBridgeFT, rootBft, bridgeFtMapCalcul, new HashSet<Integer>(this.m_parsed));
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], second iteration on failed. no topology found. {}, \n{}", new Object[]{failedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            this.m_parsed.add(failedbridgeid);
            this.m_failed.remove(failedbridgeid);
        }
        for (Integer postprocessbridgeid : new HashSet(postprocessing)) {
            if (postprocessbridgeid == null) {
                LOG.error("calculate: bridge:[null], postprocessbridge");
                continue;
            }
            BridgeForwardingTable postprocessBridgeFT = this.m_bridgeFtMapUpdate.get(postprocessbridgeid);
            if (postprocessBridgeFT == null) {
                LOG.error("calculate: bridge:[{}],postprocessbridge. FT is null", (Object)postprocessbridgeid);
                continue;
            }
            BridgeSimpleConnection simpleConnection = BridgeSimpleConnection.create(rootBft, postprocessBridgeFT);
            try {
                simpleConnection.findSimpleConnection();
                this.down(rootBft, postprocessBridgeFT, simpleConnection, bridgeFtMapCalcul, 0);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], postprocessbridge. No topology found for single port node. {}, \n{}", new Object[]{postprocessbridgeid, e.getMessage(), e.printTopology()});
                this.m_failed.add(postprocessbridgeid);
                continue;
            }
            this.m_parsed.add(postprocessbridgeid);
        }
        for (Integer failedbridgeid : new HashSet<Integer>(this.m_failed)) {
            if (failedbridgeid == null) {
                LOG.error("calculate: bridge:[null], third iteration on failed");
                continue;
            }
            failedBridgeFT = this.m_bridgeFtMapUpdate.get(failedbridgeid);
            if (failedBridgeFT == null) {
                LOG.error("calculate: bridge:[{}], third iteration on failed. FT is null", (Object)failedbridgeid);
                continue;
            }
            try {
                this.postprocess(failedBridgeFT, rootBft, bridgeFtMapCalcul, new HashSet<Integer>(this.m_parsed));
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], third iteration on failed. no topology found. {}, \n{}", new Object[]{failedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            this.m_parsed.add(failedbridgeid);
            this.m_failed.remove(failedbridgeid);
        }
        this.m_bridgeFtMapUpdate.values().stream().filter(ft -> this.m_parsed.contains(ft.getNodeId())).forEach(this.m_domain::addforwarders);
        bridgeFtMapCalcul.values().forEach(this.m_domain::addforwarders);
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: domain\n{}", (Object)this.m_domain.printTopology());
        }
    }

    private void postprocess(BridgeForwardingTable postBridgeFT, BridgeForwardingTable rootBridgeFT, Map<Integer, BridgeForwardingTable> bridgeFtMapCalcul, Set<Integer> parsed) throws BridgeTopologyException {
        Integer postbridgeid = postBridgeFT.getBridge().getNodeId();
        for (Integer parsedbridgeid : parsed) {
            if (parsedbridgeid.intValue() == rootBridgeFT.getNodeId().intValue()) continue;
            BridgeForwardingTable parsedBridgeFT = this.m_bridgeFtMapUpdate.get(parsedbridgeid);
            if (parsedBridgeFT == null) {
                parsedBridgeFT = bridgeFtMapCalcul.get(parsedbridgeid);
            }
            BridgeSimpleConnection sp = BridgeSimpleConnection.create(parsedBridgeFT, postBridgeFT);
            try {
                sp.findSimpleConnection();
            }
            catch (BridgeTopologyException e) {
                LOG.warn("postprocess: bridge:[{}] <--> bridge:[{}] no topology found. {}, \n{}", new Object[]{postbridgeid, parsedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            if (parsedBridgeFT.getBridge().isRootBridge() || parsedBridgeFT.getRootPort().equals(sp.getFirstPort())) continue;
            if (postBridgeFT.getBridge().isNewTopology()) {
                postBridgeFT.setRootPort(sp.getSecondBridgePort());
            }
            try {
                this.down(parsedBridgeFT, postBridgeFT, sp, bridgeFtMapCalcul, 0);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("postprocess: bridge:[{}] <--> bridge:[{}] no topology found. {}, \n{}", new Object[]{postbridgeid, parsedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("postprocess: bridge:[{}] <--> bridge:[{}] topology found.", (Object)postbridgeid, (Object)parsedbridgeid);
            }
            return;
        }
        BridgeSimpleConnection simpleConnection = BridgeSimpleConnection.create(rootBridgeFT, postBridgeFT);
        try {
            simpleConnection.findSimpleConnection();
            this.down(rootBridgeFT, postBridgeFT, simpleConnection, bridgeFtMapCalcul, 0);
            return;
        }
        catch (BridgeTopologyException e) {
            LOG.warn("postprocess: bridge:[{}] <--> bridge:[{}] no topology found. {}, \n{}", new Object[]{postbridgeid, rootBridgeFT.getNodeId(), e.getMessage(), e.printTopology()});
            throw new BridgeTopologyException("postprocess: no connection found", postBridgeFT);
        }
    }

    private void down(BridgeForwardingTable bridgeUpFT, BridgeForwardingTable bridgeFT, BridgeSimpleConnection upsimpleconn, Map<Integer, BridgeForwardingTable> bridgeFtMapCalcul, Integer level) throws BridgeTopologyException {
        if ((level = Integer.valueOf(level + 1)) == 30) {
            throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], too many iteration");
        }
        SharedSegment upSegment = this.m_domain.getSharedSegment(upsimpleconn.getFirstPort());
        if (upSegment == null) {
            throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], up segment not found");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("down: level: {}, bridge:[{}]. up segment -> \n{} ", new Object[]{level, bridgeFT.getNodeId(), upSegment.printTopology()});
        }
        HashSet<BridgePort> parsed = new HashSet<BridgePort>();
        parsed.add(bridgeFT.getRootPort());
        HashSet<BridgeForwardingTable> checkforwarders = new HashSet<BridgeForwardingTable>();
        checkforwarders.add(bridgeUpFT);
        checkforwarders.add(bridgeFT);
        HashMap<BridgePortWithMacs, Set<BridgePortWithMacs>> splitted = new HashMap<BridgePortWithMacs, Set<BridgePortWithMacs>>();
        BridgeForwardingTable nextDownBridge = null;
        BridgeSimpleConnection nextDownSP = null;
        boolean levelfound = false;
        Set<String> maconupsegment = DiscoveryBridgeTopology.getMacs(bridgeUpFT, bridgeFT, upsimpleconn);
        for (Bridge curbridge : this.m_domain.getBridgeOnSharedSegment(upSegment)) {
            if (curbridge.getNodeId().intValue() == upSegment.getDesignatedBridge().intValue()) continue;
            BridgeForwardingTable curBridgeFT = this.m_bridgeFtMapUpdate.get(curbridge.getNodeId());
            if (curBridgeFT == null) {
                curBridgeFT = bridgeFtMapCalcul.get(curbridge.getNodeId());
            }
            if (curBridgeFT == null) {
                throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], no bft for: " + curbridge.printTopology());
            }
            checkforwarders.add(curBridgeFT);
            BridgeSimpleConnection simpleconn = BridgeSimpleConnection.create(curBridgeFT, bridgeFT);
            simpleconn.findSimpleConnection();
            if (LOG.isDebugEnabled()) {
                LOG.debug("down: level: {}, bridge:[{}]. {}", new Object[]{level, bridgeFT.getNodeId(), simpleconn.printTopology()});
            }
            if (!Objects.equals(simpleconn.getSecondBridgePort(), bridgeFT.getBridge().getRootPort()) && !Objects.equals(simpleconn.getFirstBridgePort(), curbridge.getRootPort())) {
                throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], Topology mismatch. NO ROOTS");
            }
            if (Objects.equals(simpleconn.getSecondBridgePort(), bridgeFT.getRootBridgePort()) && !Objects.equals(simpleconn.getFirstBridgePort(), curbridge.getRootPort())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("down: level: {}, bridge: [{}], is 'down' of -> {}", new Object[]{level, bridgeFT.getNodeId(), simpleconn.getFirstPort().printTopology()});
                }
                if (nextDownBridge != null) {
                    throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], Topology mismatch. LEAF OF TWO");
                }
                if (levelfound) {
                    throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], Topology mismatch. LEAF AND LEVEL FOUND");
                }
                nextDownBridge = curBridgeFT;
                nextDownSP = simpleconn;
                continue;
            }
            if (Objects.equals(simpleconn.getFirstBridgePort(), curBridgeFT.getRootBridgePort()) && !Objects.equals(simpleconn.getSecondBridgePort(), bridgeFT.getRootBridgePort())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("down: level: {}, bridge: [{}], {} is 'up' of -> [{}]", new Object[]{level, bridgeFT.getNodeId(), simpleconn.getSecondPort().printTopology(), curbridge.getNodeId()});
                }
                if (nextDownBridge != null) {
                    throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], Topology mismatch. LEAF AND LEVEL FOUND");
                }
                levelfound = true;
                if (!splitted.containsKey(bridgeFT.getBridgePortWithMacs(simpleconn.getSecondPort()))) {
                    splitted.put(bridgeFT.getBridgePortWithMacs(simpleconn.getSecondPort()), new HashSet());
                }
                ((Set)splitted.get(bridgeFT.getBridgePortWithMacs(simpleconn.getSecondPort()))).add(curBridgeFT.getBridgePortWithMacs(simpleconn.getFirstPort()));
                parsed.add(simpleconn.getSecondPort());
                continue;
            }
            maconupsegment.retainAll(DiscoveryBridgeTopology.getMacs(curBridgeFT, bridgeFT, simpleconn));
        }
        if (nextDownBridge != null) {
            this.down(nextDownBridge, bridgeFT, nextDownSP, bridgeFtMapCalcul, level);
            return;
        }
        this.m_domain.merge(upSegment, splitted, maconupsegment, bridgeFT.getRootPort(), DiscoveryBridgeTopology.getThroughSet(bridgeFT, parsed));
        checkforwarders.forEach(this.m_domain::addforwarders);
    }
}

