/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats.RouteInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRouteInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRouteInfoDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RouteInfoClient {
    private static final Logger LOG = LoggerFactory.getLogger(RouteInfoClient.class);
    private static final Integer DEFAULT_HOUR_OF_THE_DAY = 1;
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("UpdateRouteInfo-%d").build();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
    private final String routeInfoDbPath;
    private Integer hourOfTheDay = DEFAULT_HOUR_OF_THE_DAY;
    @Autowired
    private BmpRouteInfoDao bmpRouteInfoDao;
    @Autowired
    private SessionUtils sessionUtils;

    public RouteInfoClient(String routeInfoDbPath) {
        this.routeInfoDbPath = routeInfoDbPath;
    }

    public void init() {
        Long midnight = LocalDateTime.now().until(LocalDate.now().plusDays(1L).atStartOfDay(), ChronoUnit.MINUTES);
        Long hourOfTheDayInMinutes = midnight + (long)(this.hourOfTheDay * 60);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.updateRouteInfo(this.routeInfoDbPath), hourOfTheDayInMinutes, TimeUnit.DAYS.toMinutes(1L), TimeUnit.MINUTES);
    }

    public void destroy() {
        this.scheduledExecutorService.shutdownNow();
    }

    @VisibleForTesting
    void updateRouteInfo(String folderName) {
        LOG.debug("Update RouteInfo ++");
        if (Strings.isNullOrEmpty((String)folderName)) {
            return;
        }
        try (Stream<Path> paths = Files.walk(Paths.get(folderName, new String[0]), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(this::parseAndSaveInDB);
        }
        catch (IOException e) {
            LOG.error("Exception while walking through files in folder {}", (Object)folderName, (Object)e);
        }
        LOG.debug("Update RouteInfo --");
    }

    private void parseAndSaveInDB(Path dbPath) {
        try {
            List<RouteInfo> returned = this.parseEachFile(dbPath);
            LOG.debug("Fetched {} routeinfo elements", (Object)returned.size());
            this.saveOrUpdateInDB(returned);
        }
        catch (Exception e) {
            LOG.error("Exception while persisting elements from path {} ", (Object)dbPath, (Object)e);
        }
    }

    @VisibleForTesting
    List<RouteInfo> parseEachFile(Path dbPath) {
        try {
            Stream<String> lines = Files.lines(dbPath);
            return RouteInfo.parseRouteInfo(lines);
        }
        catch (IOException e) {
            LOG.error("Exception while reading lines from path {} ", (Object)dbPath, (Object)e);
            return new ArrayList<RouteInfo>();
        }
    }

    private void saveOrUpdateInDB(List<RouteInfo> routeInfos) {
        HashSet<RouteInfo> batchedRouteInfo = new HashSet<RouteInfo>();
        for (int i = 0; i < routeInfos.size(); ++i) {
            batchedRouteInfo.add(routeInfos.get(i));
            if ((i % 100 != 0 || i == 0) && i != routeInfos.size() - 1) continue;
            if (Thread.currentThread().isInterrupted()) break;
            Set<BmpRouteInfo> bmpRouteInfoList = this.buildBmpRouteInfoList(batchedRouteInfo);
            this.saveOrUpdateInSession(bmpRouteInfoList);
            batchedRouteInfo = new HashSet();
        }
    }

    private void saveOrUpdateInSession(Set<BmpRouteInfo> bmpRouteInfos) {
        this.sessionUtils.withTransaction(() -> bmpRouteInfos.forEach(routeInfo -> {
            try {
                this.bmpRouteInfoDao.saveOrUpdate(routeInfo);
            }
            catch (Exception e) {
                LOG.error("Exception while persisting BMP Route Info {}", routeInfo, (Object)e);
            }
        }));
    }

    private BmpRouteInfo buildBmpRouteInfo(RouteInfo routeInfo) {
        String prefix = routeInfo.getPrefix();
        Integer prefixLen = routeInfo.getPrefixLen();
        Long originAs = routeInfo.getOriginAs();
        String source = routeInfo.getSource();
        if (prefix != null && originAs != null && prefixLen != null && source != null) {
            BmpRouteInfo bmpRouteInfo = this.bmpRouteInfoDao.findByPrefixAndOriginAs(prefix, prefixLen, originAs);
            if (bmpRouteInfo == null) {
                bmpRouteInfo = new BmpRouteInfo();
                bmpRouteInfo.setPrefix(prefix);
                bmpRouteInfo.setPrefixLen(prefixLen);
                bmpRouteInfo.setOriginAs(originAs);
                bmpRouteInfo.setDescr(routeInfo.getDescription());
                bmpRouteInfo.setSource(routeInfo.getSource());
            }
            bmpRouteInfo.setLastUpdated(Date.from(Instant.now()));
            return bmpRouteInfo;
        }
        return null;
    }

    private Set<BmpRouteInfo> buildBmpRouteInfoList(Set<RouteInfo> routeInfoList) {
        HashSet<BmpRouteInfo> bmpRouteInfoSet = new HashSet<BmpRouteInfo>();
        routeInfoList.forEach(routeInfo -> {
            BmpRouteInfo bmpRouteInfo = this.buildBmpRouteInfo((RouteInfo)routeInfo);
            if (bmpRouteInfo != null) {
                bmpRouteInfoSet.add(bmpRouteInfo);
            }
        });
        return bmpRouteInfoSet;
    }

    public void setBmpRouteInfoDao(BmpRouteInfoDao bmpRouteInfoDao) {
        this.bmpRouteInfoDao = bmpRouteInfoDao;
    }

    public void setSessionUtils(SessionUtils sessionUtils) {
        this.sessionUtils = sessionUtils;
    }

    public void setHourOfTheDay(Integer hourOfTheDay) {
        this.hourOfTheDay = hourOfTheDay;
    }
}

