/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.api;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;

public interface RpcClientFactory {
    public static final String LOG_PREFIX = "ipc";
    public static final String JMX_DOMAIN_RPC = "org.opennms.core.ipc.rpc";
    public static final String RPC_REQUEST_SENT = "requestSent";
    public static final String RPC_REQUESTS_RECEIVED = "requestsReceived";
    public static final String RPC_FAILED = "requestFailed";
    public static final String RPC_DURATION = "duration";
    public static final String RPC_REQUEST_SIZE = "requestSize";
    public static final String RPC_RESPONSE_SIZE = "responseSize";

    public <R extends RpcRequest, S extends RpcResponse> RpcClient<R, S> getClient(RpcModule<R, S> var1);

    public static void updateDuration(MetricRegistry metricRegistry, String location, String moduleId, long duration) {
        Histogram histogram = metricRegistry.histogram(MetricRegistry.name((String)location, (String[])new String[]{moduleId, RPC_DURATION}));
        histogram.update(duration);
    }

    public static void markRpcCount(MetricRegistry metricRegistry, String location, String moduleId) {
        Meter rpcCount = metricRegistry.meter(MetricRegistry.name((String)location, (String[])new String[]{moduleId, RPC_REQUEST_SENT}));
        rpcCount.mark();
    }

    public static void updateRequestSize(MetricRegistry metricRegistry, String location, String moduleId, int requestSize) {
        Histogram histogram = metricRegistry.histogram(MetricRegistry.name((String)location, (String[])new String[]{moduleId, RPC_REQUEST_SIZE}));
        histogram.update(requestSize);
    }

    public static void updateResponseSize(MetricRegistry metricRegistry, String location, String moduleId, int responseSize) {
        Histogram histogram = metricRegistry.histogram(MetricRegistry.name((String)location, (String[])new String[]{moduleId, RPC_RESPONSE_SIZE}));
        histogram.update(responseSize);
    }

    public static void markFailed(MetricRegistry metricRegistry, String location, String moduleId) {
        Meter failed = metricRegistry.meter(MetricRegistry.name((String)location, (String[])new String[]{moduleId, RPC_FAILED}));
        failed.mark();
    }
}

