/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset.cmd;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.topology.plugins.topo.asset.AssetGraphMLProvider;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfig;

@Command(scope="opennms", name="asset-topo-remove", description="Removes Asset Topology. Uses default config if options not supplied")
@Service
public class RemoveAssetTopologyCommand
implements Action {
    @Reference
    public AssetGraphMLProvider assetGraphMLProvider;
    @Argument(index=0, name="providerId", description="Unique providerId of asset topology (optional)", required=false, multiValued=false)
    String providerId = new GeneratorConfig().getProviderId();

    public Object execute() {
        if (this.providerId == null || this.providerId.trim().isEmpty()) {
            this.providerId = new GeneratorConfig().getProviderId();
        }
        System.out.println("Removing Asset Topology for providerId=" + this.providerId);
        this.assetGraphMLProvider.removeAssetTopology(this.providerId);
        System.out.println("Removed Asset Topology for providerId=" + this.providerId);
        return null;
    }
}

