/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.breadcrumbs.BreadcrumbStrategy;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfig;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.model.events.EventUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorConfigBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorConfigBuilder.class);
    private String label;
    private String breadcrumbStrategy;
    private String providerId;
    private String preferredLayout;
    private String hierarchy = String.join((CharSequence)",", "asset-region", "asset-building", "asset-rack");
    private String filter;

    public GeneratorConfigBuilder withLabel(String label) {
        this.label = label;
        return this;
    }

    public GeneratorConfigBuilder withBreadcrumbStrategy(String breadcrumbStrategy) {
        this.breadcrumbStrategy = breadcrumbStrategy;
        return this;
    }

    public GeneratorConfigBuilder withProviderId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    public GeneratorConfigBuilder withPreferredLayout(String preferredLayout) {
        this.preferredLayout = preferredLayout;
        return this;
    }

    public GeneratorConfigBuilder withHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
        return this;
    }

    public GeneratorConfigBuilder withFilters(String filter) {
        this.filter = filter;
        return this;
    }

    public GeneratorConfig build() {
        GeneratorConfig config = new GeneratorConfig();
        if (this.label != null) {
            config.setLabel(this.label);
        }
        if (this.providerId != null) {
            config.setProviderId(this.providerId);
            if (this.label == null) {
                config.setLabel(this.providerId);
            }
        }
        if (this.preferredLayout != null) {
            config.setPreferredLayout(this.preferredLayout);
        }
        if (this.hierarchy != null && !this.hierarchy.trim().isEmpty()) {
            List<String> layers = Arrays.asList(this.hierarchy.split(",")).stream().filter(Objects::nonNull).map(String::trim).filter(h -> !h.isEmpty()).collect(Collectors.toList());
            config.setLayerHierarchies(layers);
        }
        if (this.filter != null && !this.filter.trim().isEmpty()) {
            List<String> filters = Arrays.asList(this.filter.split(";")).stream().filter(Objects::nonNull).map(String::trim).filter(h -> !h.isEmpty()).collect(Collectors.toList());
            config.setFilters(filters);
        }
        if (this.breadcrumbStrategy != null) {
            try {
                BreadcrumbStrategy validValue = BreadcrumbStrategy.valueOf((String)this.breadcrumbStrategy);
                config.setBreadcrumbStrategy(validValue.name());
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("Given breadcrumbStrategy {} does not exist. Valid values are {}. Ignoring.", (Object)this.breadcrumbStrategy, (Object)BreadcrumbStrategy.values());
            }
        }
        return config;
    }

    public static GeneratorConfig buildFrom(IEvent e) {
        String label = EventUtils.getParm((IEvent)e, (String)"label");
        String breadcrumbStrategy = EventUtils.getParm((IEvent)e, (String)"breadcrumbStrategy");
        String providerId = EventUtils.getParm((IEvent)e, (String)"providerId");
        String filters = EventUtils.getParm((IEvent)e, (String)"filters");
        String preferredLayout = EventUtils.getParm((IEvent)e, (String)"preferredLayout");
        String hierarchy = EventUtils.getParm((IEvent)e, (String)"assetLayers");
        return new GeneratorConfigBuilder().withLabel(label).withBreadcrumbStrategy(breadcrumbStrategy).withProviderId(providerId).withPreferredLayout(preferredLayout).withHierarchy(hierarchy).withFilters(filters).build();
    }
}

