/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy;
import com.datastax.oss.driver.internal.core.ssl.DefaultSslEngineFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.cassandra.CassandraException;
import org.opennms.newts.cassandra.CassandraSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSessionImpl
implements CassandraSession {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSessionImpl.class);
    private final CqlSession m_session;

    public CassandraSessionImpl(@Named(value="cassandra.datacenter") String datacenter, @Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.hostname") String hostname, @Named(value="cassandra.port") int port, @Named(value="cassandra.compression") String compression, @Named(value="cassandra.username") String username, @Named(value="cassandra.password") String password, @Named(value="cassandra.ssl") boolean ssl) {
        this(datacenter, keyspace, hostname, port, compression, username, password, ssl, null, null, null);
    }

    public CassandraSessionImpl(@Named(value="cassandra.datacenter") String datacenter, @Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.hostname") String hostname, @Named(value="cassandra.port") int port, @Named(value="cassandra.compression") String compression, @Named(value="cassandra.username") String username, @Named(value="cassandra.password") String password, @Named(value="cassandra.ssl") boolean ssl, @Named(value="cassandra.driver-settings-file") String driverSettingsFile) {
        this(datacenter, keyspace, hostname, port, compression, username, password, ssl, null, null, driverSettingsFile);
    }

    @Inject
    public CassandraSessionImpl(@Named(value="cassandra.datacenter") String datacenter, @Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.hostname") String hostname, @Named(value="cassandra.port") int port, @Named(value="cassandra.compression") String compression, @Named(value="cassandra.username") String username, @Named(value="cassandra.password") String password, @Named(value="cassandra.ssl") boolean ssl, @Named(value="cassandra.pool.connections-per-host") Integer connectionsPerHost, @Named(value="cassandra.pool.max-requests-per-connection") Integer maxRequestsPerConnection, @Named(value="cassandra.driver-settings-file") String driverSettingsFile) {
        if (!Strings.isNullOrEmpty((String)driverSettingsFile)) {
            File settingsFile = new File(driverSettingsFile);
            LOG.info("Setting up session with settings file: {}", (Object)settingsFile);
            this.m_session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(DefaultDriverConfigLoader.fromFile((File)settingsFile))).withKeyspace(keyspace)).build();
            return;
        }
        Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter argument");
        Preconditions.checkNotNull((Object)keyspace, (Object)"keyspace argument");
        Preconditions.checkNotNull((Object)hostname, (Object)"hostname argument");
        Preconditions.checkArgument((port > 0 && port < 65535 ? 1 : 0) != 0, (String)"not a valid port number: %d", (int)port);
        Preconditions.checkNotNull((Object)compression, (Object)"compression argument");
        LOG.info("Setting up session with to {}:{} using compression {} and local datacenter: {}", new Object[]{hostname, port, compression.toUpperCase(), datacenter});
        ProgrammaticDriverConfigLoaderBuilder configBuilder = DriverConfigLoader.programmaticBuilder().startProfile("default");
        configBuilder.withString((DriverOption)DefaultDriverOption.SESSION_KEYSPACE, keyspace);
        configBuilder.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, CassandraSessionImpl.toContactPoints(hostname, port));
        if (connectionsPerHost != null) {
            LOG.debug("Using {} connections per host.", (Object)connectionsPerHost);
            configBuilder.withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE, connectionsPerHost.intValue());
            configBuilder.withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE, connectionsPerHost.intValue());
        }
        if (maxRequestsPerConnection != null) {
            LOG.debug("Using {} max requests per connection.", (Object)maxRequestsPerConnection);
            configBuilder.withInt((DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS, maxRequestsPerConnection.intValue());
        }
        configBuilder.withClass((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, ExponentialReconnectionPolicy.class);
        configBuilder.withDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.of(1L, ChronoUnit.SECONDS));
        configBuilder.withDuration((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY, Duration.of(2L, ChronoUnit.MINUTES));
        configBuilder.withString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, compression.toUpperCase());
        if (username != null && password != null) {
            LOG.info("Using username: {} and password: XXXXXXXX", (Object)username);
            configBuilder.withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, username);
            configBuilder.withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, password);
        }
        if (ssl) {
            configBuilder.withString((DriverOption)DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, DefaultSslEngineFactory.class.getCanonicalName());
        }
        this.m_session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(configBuilder.build())).withLocalDatacenter(datacenter)).build();
    }

    protected static List<String> toContactPoints(String hostname, int port) {
        return Arrays.stream(hostname.split(",")).map(host -> {
            if (host.indexOf(":") > 0) {
                return host;
            }
            return String.format("%s:%d", host, port);
        }).collect(Collectors.toList());
    }

    @Override
    public PreparedStatement prepare(String statement) {
        try {
            return this.m_session.prepare(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public PreparedStatement prepare(SimpleStatement statement) {
        try {
            return this.m_session.prepare(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public CompletionStage<AsyncResultSet> executeAsync(Statement statement) {
        try {
            return this.m_session.executeAsync(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public ResultSet execute(Statement statement) {
        try {
            return this.m_session.execute(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public ResultSet execute(String statement) {
        try {
            return this.m_session.execute(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public CompletionStage<Void> shutdown() {
        return this.m_session.closeAsync();
    }
}

