/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.net.URI;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.resource.internal.AbstractResourceProvider;

public abstract class PathBasedResourceProvider
extends AbstractResourceProvider {
    private final String _root;

    public PathBasedResourceProvider(String root) {
        root = URI.create(root).normalize().getPath();
        this._root = PathUtils.addLeadingSlash(root);
    }

    protected String getFullPath(String path) {
        return PathUtils.addPaths(this._root, path);
    }

    protected String getRelativePath(String fullPath) {
        return PathUtils.addLeadingSlash(fullPath.substring(this._root.length()));
    }

    public String getRoot() {
        return this._root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathBasedResourceProvider that = (PathBasedResourceProvider)o;
        return this._root.equals(that._root);
    }

    public int hashCode() {
        return this._root.hashCode();
    }
}

