/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.message.AMQPNativeInboundTransformer;
import org.apache.activemq.transport.amqp.message.AmqpMessageSupport;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.InboundTransformer;
import org.apache.activemq.util.ByteSequence;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class JMSMappingInboundTransformer
extends InboundTransformer {
    @Override
    public String getTransformerName() {
        return "jms";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return new AMQPNativeInboundTransformer();
    }

    @Override
    protected ActiveMQMessage doTransform(EncodedMessage amqpMessage) throws Exception {
        Message amqp = amqpMessage.decode();
        ActiveMQMessage result = this.createMessage(amqp, amqpMessage);
        this.populateMessage(result, amqp);
        if (amqpMessage.getMessageFormat() != 0L) {
            result.setLongProperty("JMS_AMQP_MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ActiveMQMessage createMessage(Message message, EncodedMessage original) throws Exception {
        ActiveMQMessage result;
        Section body = message.getBody();
        if (body == null) {
            Charset charset;
            result = AmqpMessageSupport.isContentType("application/x-java-serialized-object", message) ? new ActiveMQObjectMessage() : (AmqpMessageSupport.isContentType("application/octet-stream", message) || AmqpMessageSupport.isContentType(null, message) ? new ActiveMQBytesMessage() : ((charset = AmqpMessageSupport.getCharsetForTextualContent(message.getContentType())) != null ? new ActiveMQTextMessage() : new ActiveMQMessage()));
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)1);
            return result;
        } else if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                result = JMSMappingInboundTransformer.createObjectMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else if (AmqpMessageSupport.isContentType("application/octet-stream", message)) {
                result = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else {
                Charset charset = AmqpMessageSupport.getCharsetForTextualContent(message.getContentType());
                if (StandardCharsets.UTF_8.equals(charset)) {
                    ByteBuffer buf = ByteBuffer.wrap(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    try {
                        CharBuffer chars = charset.newDecoder().decode(buf);
                        result = JMSMappingInboundTransformer.createTextMessage(String.valueOf(chars));
                    }
                    catch (CharacterCodingException e) {
                        result = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    }
                } else {
                    result = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                }
            }
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)2);
            return result;
        } else if (body instanceof AmqpSequence) {
            AmqpSequence sequence = (AmqpSequence)body;
            ActiveMQStreamMessage m = new ActiveMQStreamMessage();
            for (Object item : sequence.getValue()) {
                m.writeObject(item);
            }
            result = m;
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)3);
            return result;
        } else {
            if (!(body instanceof AmqpValue)) throw new RuntimeException("Unexpected body type: " + body.getClass());
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                result = JMSMappingInboundTransformer.createTextMessage((String)value);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", value == null ? (short)4 : 5);
                return result;
            } else if (value instanceof Binary) {
                Binary payload = (Binary)value;
                result = AmqpMessageSupport.isContentType("application/x-java-serialized-object", message) ? JMSMappingInboundTransformer.createObjectMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength()) : JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)6);
                return result;
            } else if (value instanceof List) {
                ActiveMQStreamMessage m = new ActiveMQStreamMessage();
                for (Object item : (List)value) {
                    m.writeObject(item);
                }
                result = m;
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)8);
                return result;
            } else {
                if (!(value instanceof Map)) throw new AmqpProtocolException("Unable to encode to ActiveMQ JMS Message", false);
                result = JMSMappingInboundTransformer.createMapMessage((Map)value);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)7);
            }
        }
        return result;
    }

    private static ActiveMQBytesMessage createBytesMessage(byte[] content, int offset, int length) {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.setContent(new ByteSequence(content, offset, length));
        return message;
    }

    public static ActiveMQTextMessage createTextMessage(String text) {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        try {
            message.setText(text);
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        return message;
    }

    public static ActiveMQObjectMessage createObjectMessage(byte[] content, int offset, int length) {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setContent(new ByteSequence(content, offset, length));
        return message;
    }

    public static ActiveMQMapMessage createMapMessage(Map<String, Object> content) throws JMSException {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        Set<Map.Entry<String, Object>> set2 = content.entrySet();
        for (Map.Entry<String, Object> entry : set2) {
            Object value = entry.getValue();
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                value = Arrays.copyOfRange(binary.getArray(), binary.getArrayOffset(), binary.getLength());
            }
            message.setObject(entry.getKey(), value);
        }
        return message;
    }
}

