/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractNodeDependentRestService<T, Q, K extends Serializable, I extends Serializable>
extends AbstractDaoRestService<T, Q, K, I> {
    @Autowired
    protected NodeDao m_nodeDao;

    protected void updateCriteria(UriInfo uriInfo, CriteriaBuilder builder) {
        builder.alias("node", Aliases.node.toString());
        String nodeCriteria = this.getNodeCriteria(uriInfo);
        if (nodeCriteria.contains(":")) {
            String[] parts = nodeCriteria.split(":");
            builder.eq("node.foreignSource", (Object)parts[0]);
            builder.eq("node.foreignId", (Object)parts[1]);
        } else {
            builder.eq("node.id", (Object)Integer.parseInt(nodeCriteria));
        }
    }

    protected OnmsNode getNode(UriInfo uriInfo) {
        String lookupCriteria = this.getNodeCriteria(uriInfo);
        return this.m_nodeDao.get(lookupCriteria);
    }

    private String getNodeCriteria(UriInfo uriInfo) {
        return ((PathSegment)uriInfo.getPathSegments(true).get(1)).getPath();
    }
}

