/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.core.svclayer.support;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.opennms.api.reporting.ReportException;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportMode;
import org.opennms.api.reporting.ReportService;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.core.logging.Logging;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.model.ReportCatalogEntry;
import org.opennms.reporting.core.DeliveryOptions;
import org.opennms.reporting.core.svclayer.ReportServiceLocator;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.opennms.reporting.core.svclayer.ReportWrapperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReportWrapperService
implements ReportWrapperService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReportWrapperService.class);
    private ReportServiceLocator m_reportServiceLocator;
    private ReportStoreService m_reportStoreService;
    private static final String LOG4J_CATEGORY = "reports";

    @Override
    public List<ReportFormat> getFormats(String reportId) {
        return this.getReportService(reportId).getFormats(reportId);
    }

    @Override
    public DeliveryOptions getDeliveryOptions(final String reportId, final String userId) {
        final DeliveryOptions options = new DeliveryOptions();
        options.setFormat(ReportFormat.HTML);
        options.setPersist(true);
        options.setSendMail(false);
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                UserManager userFactory = UserFactory.getInstance();
                try {
                    String emailAddress = userFactory.getEmail(userId);
                    if (emailAddress != null && !emailAddress.isEmpty()) {
                        options.setMailTo(emailAddress);
                    }
                }
                catch (Exception e) {
                    LOG.error("An error occurred while attempting to determine and set the destination email address for user {}", (Object)userId, (Object)e);
                }
                options.setInstanceId(reportId + " " + userId);
            }
        });
        return options;
    }

    @Override
    public ReportParameters getParameters(final String reportId) {
        try {
            return (ReportParameters)Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<ReportParameters>(){

                @Override
                public ReportParameters call() throws Exception {
                    try {
                        return DefaultReportWrapperService.this.getReportService(reportId).getParameters(reportId);
                    }
                    catch (ReportException e) {
                        LOG.error("Report Exception when retrieving report parameters", (Throwable)e);
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Boolean hasParameters(String reportId) {
        Map reportParms = this.getParameters(reportId).getReportParms();
        if (reportParms == null || reportParms.isEmpty()) {
            return false;
        }
        return true;
    }

    @Override
    public void render(final String reportId, final String location, final ReportFormat format, final OutputStream outputStream) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultReportWrapperService.this.getReportService(reportId).render(reportId, location, format, outputStream);
                }
                catch (ReportException e) {
                    LOG.error("Failed to render report", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void run(final ReportParameters parameters, final ReportMode mode, final DeliveryOptions deliveryOptions, final String reportId) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedOutputStream bout;
                ByteArrayOutputStream out;
                block10: {
                    out = null;
                    bout = null;
                    try {
                        out = new ByteArrayOutputStream();
                        bout = new BufferedOutputStream(out);
                        Map reportParameters = parameters.getReportParms(mode);
                        if (!deliveryOptions.isPersist()) {
                            try {
                                DefaultReportWrapperService.this.getReportService(reportId).runAndRender(reportParameters, reportId, deliveryOptions.getFormat(), (OutputStream)bout);
                                if (deliveryOptions.isSendMail() && deliveryOptions.getMailTo().length() != 0) {
                                    DefaultReportWrapperService.mailReport(deliveryOptions, out);
                                }
                                if (deliveryOptions.isWebhook()) {
                                    DefaultReportWrapperService.postReport(deliveryOptions, reportParameters, out, deliveryOptions.getInstanceId() + "." + deliveryOptions.getFormat().name().toLowerCase());
                                }
                                break block10;
                            }
                            catch (ReportException reportException) {
                                DefaultReportWrapperService.logError(reportId, (Exception)((Object)reportException));
                            }
                            break block10;
                        }
                        String outputPath = DefaultReportWrapperService.this.getReportService(reportId).run(reportParameters, reportId);
                        ReportCatalogEntry catalogEntry = new ReportCatalogEntry();
                        catalogEntry.setReportId(reportId);
                        catalogEntry.setTitle(deliveryOptions.getInstanceId());
                        catalogEntry.setLocation(outputPath);
                        catalogEntry.setDate(new Date());
                        DefaultReportWrapperService.this.m_reportStoreService.save(catalogEntry);
                        if (!deliveryOptions.isSendMail() && !deliveryOptions.isWebhook()) break block10;
                        DefaultReportWrapperService.this.getReportService(reportId).render(reportId, outputPath, deliveryOptions.getFormat(), (OutputStream)bout);
                        if (deliveryOptions.isSendMail() && deliveryOptions.getMailTo().length() != 0) {
                            DefaultReportWrapperService.mailReport(deliveryOptions, out);
                        }
                        if (!deliveryOptions.isWebhook()) break block10;
                        String fileName = Paths.get(catalogEntry.getLocation(), new String[0]).getFileName().toString().replaceAll("jrprint", "");
                        DefaultReportWrapperService.postReport(deliveryOptions, reportParameters, out, fileName + deliveryOptions.getFormat().name().toLowerCase());
                    }
                    catch (Exception e) {
                        try {
                            DefaultReportWrapperService.logError(reportId, e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(bout);
                            IOUtils.closeQuietly((OutputStream)out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)bout);
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                }
                IOUtils.closeQuietly((OutputStream)bout);
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
    }

    private static void logError(String reportId, Exception exception) {
        LOG.error("failed to run or render report: {}", (Object)reportId, (Object)exception);
    }

    private static void postReport(DeliveryOptions deliveryOptions, Map<String, Object> reportParameters, ByteArrayOutputStream outputStream, String fileName) {
        String url = deliveryOptions.getWebhookUrl();
        String substitutedUrl = DefaultReportWrapperService.substituteUrl(url, deliveryOptions, reportParameters);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
             CloseableHttpClient client = HttpClients.createDefault();){
            LOG.debug("Posting generated report with name {} to endpoint {} (input was {})", new Object[]{fileName, substitutedUrl, url});
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("file", (InputStream)inputStream, ContentType.DEFAULT_BINARY, fileName).build();
            HttpPost httpPost = new HttpPost(substitutedUrl);
            httpPost.setEntity(entity);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                LOG.debug("Request performed. Received response: {}", (Object)response);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200 || statusCode > 299) {
                    throw new IOException("Expected status code of >= 200 and <= 299 but received: " + statusCode + ". Reason: " + response.getStatusLine().getReasonPhrase());
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Error while posting data to endpoint {}: {}", new Object[]{url, ex.getMessage(), ex});
        }
    }

    protected static String substituteUrl(String url, DeliveryOptions deliveryOptions, Map<String, Object> reportParameters) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        reportParameters.entrySet().forEach(e -> parameters.put("parameter_" + (String)e.getKey(), e.getValue()));
        parameters.put("instanceId", deliveryOptions.getInstanceId());
        parameters.put("format", deliveryOptions.getFormat().name());
        String newUrl = DefaultReportWrapperService.substituteUrl(url, parameters);
        return newUrl;
    }

    protected static String substituteUrl(String url, Map<String, Object> parameters) {
        if (url.contains(":")) {
            String newUrl = url;
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    newUrl = newUrl.replaceAll(":" + entry.getKey(), URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("Could not find encoder: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            return newUrl;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mailReport(DeliveryOptions deliveryOptions, ByteArrayOutputStream outputStream) {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            JavaMailer jm = new JavaMailer();
            jm.setTo(deliveryOptions.getMailTo());
            jm.setSubject(deliveryOptions.getInstanceId());
            jm.setMessageText("Here is your report from the OpenNMS report service.");
            jm.setInputStream((InputStream)inputStream);
            switch (deliveryOptions.getFormat()) {
                case PDF: 
                case SVG: {
                    jm.setInputStreamName(deliveryOptions.getInstanceId() + ".pdf");
                    jm.setInputStreamContentType("application/pdf");
                    break;
                }
                case CSV: {
                    jm.setInputStreamName(deliveryOptions.getInstanceId() + ".csv");
                    jm.setInputStreamContentType("text/csv");
                    break;
                }
                default: {
                    jm.setInputStreamName(deliveryOptions.getInstanceId() + ".htm");
                    jm.setInputStreamContentType("text/html");
                }
            }
            jm.mailSend();
        }
        catch (JavaMailerException e) {
            try {
                LOG.error("Caught JavaMailer exception sending report", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    private ReportService getReportService(String reportId) {
        return this.m_reportServiceLocator.getReportServiceForId(reportId);
    }

    public void setReportServiceLocator(ReportServiceLocator reportServiceLocator) {
        this.m_reportServiceLocator = reportServiceLocator;
    }

    public void setReportStoreService(ReportStoreService reportStoreService) {
        this.m_reportStoreService = reportStoreService;
    }

    @Override
    public void runAndRender(ReportParameters parameters, ReportMode mode, OutputStream outputStream) throws ReportException {
        if (LOG.isDebugEnabled()) {
            Map reportParms = parameters.getReportParms(mode);
            for (Map.Entry entry : reportParms.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                LOG.debug("param {} set {}", (Object)key, (Object)(value == null ? "NULL" : value));
            }
        }
        try {
            this.getReportService(parameters.getReportId()).runAndRender(parameters.getReportParms(mode), parameters.getReportId(), parameters.getFormat(), outputStream);
        }
        catch (ReportException reportException) {
            DefaultReportWrapperService.logError(parameters.getReportId(), (Exception)((Object)reportException));
            throw reportException;
        }
    }
}

