/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client;

import java.io.IOException;
import org.opennms.features.elastic.client.DefaultElasticRestClient;
import org.opennms.features.elastic.client.ElasticRestClient;

public class ElasticRestClientFactory {
    private final String elasticHosts;
    private final String elasticUsername;
    private final String elasticPassword;
    private int connTimeout = 5000;
    private int readTimeout = 30000;
    private int bulkRetryCount = 5;
    private int retryCooldown = 500;
    private ElasticRestClient elasticRestClient;

    public ElasticRestClientFactory(String elasticHosts, String elasticUsername, String elasticPassword) {
        this.elasticHosts = elasticHosts;
        this.elasticUsername = elasticUsername;
        this.elasticPassword = elasticPassword;
    }

    public ElasticRestClient createClient() {
        if (this.elasticRestClient == null) {
            DefaultElasticRestClient client = new DefaultElasticRestClient(this.elasticHosts, this.elasticUsername, this.elasticPassword);
            client.setBulkRetryCount(this.bulkRetryCount);
            client.setConnTimeout(this.connTimeout);
            client.setReadTimeout(this.readTimeout);
            client.setRetryCooldown(this.retryCooldown);
            this.elasticRestClient = client;
        }
        return this.elasticRestClient;
    }

    public void closeClient() throws IOException {
        if (this.elasticRestClient != null) {
            this.elasticRestClient.close();
        }
    }

    public ElasticRestClient getClient() {
        return this.elasticRestClient;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setBulkRetryCount(int bulkRetryCount) {
        this.bulkRetryCount = bulkRetryCount;
    }

    public void setRetryCooldown(int retryCooldown) {
        this.retryCooldown = retryCooldown;
    }
}

