/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;

public class NotificationPacket
implements Packet {
    public final Header header;
    public final int code;
    public final int subcode;

    public NotificationPacket(Header header, ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) {
        this.header = Objects.requireNonNull(header);
        this.code = BufferUtils.uint8((ByteBuf)buffer);
        this.subcode = BufferUtils.uint8((ByteBuf)buffer);
        BufferUtils.skip((ByteBuf)buffer, (int)buffer.readableBytes());
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    public static Optional<NotificationPacket> parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        Header header = new Header(buffer);
        if (header.type != Header.Type.NOTIFICATION) {
            BmpParser.RATE_LIMITED_LOG.debug("Expected Notification Message, got: {}", (Object)header.type);
            BufferUtils.skip((ByteBuf)buffer, (int)(header.length - 19));
            return Optional.empty();
        }
        return Optional.of(new NotificationPacket(header, BufferUtils.slice((ByteBuf)buffer, (int)(header.length - 19)), flags, peerInfo));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("code", this.code).add("subcode", this.subcode).toString();
    }
}

