/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.opennms.netmgt.config.users.User;
import org.opennms.web.springframework.security.LoginHandler;
import org.opennms.web.springframework.security.OpenNMSLoginHandler;
import org.opennms.web.springframework.security.SpringSecurityUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.StringUtils;

public abstract class LoginModuleUtils {
    public static volatile Logger LOG = LoggerFactory.getLogger(LoginModuleUtils.class);
    private static final String[] INVALID_SAVED_REQUEST_URL_SUFFIXES = new String[]{".css", ".js", ".ttf"};

    protected LoginModuleUtils() {
    }

    public static boolean doLogin(OpenNMSLoginHandler handler, Subject subject, Map<String, ?> sharedState, Map<String, ?> options) throws LoginException {
        SpringSecurityUser onmsUser;
        User configUser;
        LOG.debug("OpenNMSLoginModule: login(): handler={}, subject={}, sharedState={}, options={}", new Object[]{handler.getClass(), subject.getClass(), sharedState, options});
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            handler.callbackHandler().handle(callbacks);
        }
        catch (IOException ioe) {
            LOG.debug("IO exception while attempting to prompt for username and password.", (Throwable)ioe);
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            LOG.debug("Username or password prompt not supported.", (Throwable)uce);
            throw new LoginException(uce.getMessage() + " not available to obtain information from user.");
        }
        String user = ((NameCallback)callbacks[0]).getName();
        handler.setUser(user);
        if (user == null) {
            String msg = "Username can not be null.";
            LOG.debug("Username can not be null.");
            throw new LoginException("Username can not be null.");
        }
        if (((PasswordCallback)callbacks[1]).getPassword() == null) {
            String msg = "Password can not be null.";
            LOG.debug("Password can not be null.");
            throw new LoginException("Password can not be null.");
        }
        String password = new String(((PasswordCallback)callbacks[1]).getPassword());
        try {
            configUser = handler.userConfig().getUser(user);
            onmsUser = handler.springSecurityUserDao().getByUsername(user);
        }
        catch (Exception e) {
            String message = "Failed to retrieve user " + user + " from OpenNMS UserConfig.";
            LOG.debug(message, (Throwable)e);
            throw new LoginException(message);
        }
        if (configUser == null) {
            String msg = "User  " + user + " does not exist.";
            LOG.debug(msg);
            throw new FailedLoginException(msg);
        }
        if (!handler.userConfig().comparePasswords(user, password)) {
            String msg = "Login failed: passwords did not match.";
            LOG.debug("Login failed: passwords did not match.");
            throw new FailedLoginException("Login failed: passwords did not match.");
        }
        boolean allowed = true;
        Set<Principal> principals = LoginModuleUtils.createPrincipals(handler, onmsUser.getAuthorities());
        handler.setPrincipals(principals);
        if (handler.requiresAdminRole()) {
            allowed = false;
            for (Principal principal : principals) {
                String name = principal.getName().toLowerCase().replaceAll("^role_", "");
                if (!"admin".equals(name)) continue;
                allowed = true;
            }
        }
        if (!allowed) {
            String msg = "User " + user + " is not an administrator!  OSGi console access is forbidden.";
            LOG.debug(msg);
            throw new LoginException(msg);
        }
        LOG.debug("Successfully logged in {}.", (Object)user);
        return true;
    }

    public static Set<Principal> createPrincipals(LoginHandler handler, Collection<? extends GrantedAuthority> collection) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (GrantedAuthority grantedAuthority : collection) {
            Set<Principal> ps = handler.createPrincipals(grantedAuthority);
            LOG.debug("granted authority: {}, principals: {}", (Object)grantedAuthority, (Object)ps.stream().map(Principal::getName).toArray());
            principals.addAll(ps);
        }
        return principals;
    }

    public static boolean isInvalidSavedRequestUrl(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            return true;
        }
        String urlLower = url.toLowerCase();
        return Arrays.stream(INVALID_SAVED_REQUEST_URL_SUFFIXES).anyMatch(urlLower::endsWith);
    }
}

