/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.web.springframework.security.AclUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthRoleToOnmsGroupMapFilterEnabler
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthRoleToOnmsGroupMapFilterEnabler.class);
    private FilterManager m_filterManager;
    private Map<String, List<String>> roleToOnmsGroupMap = new HashMap<String, List<String>>();

    public void setRoleToOnmsGroupMap(Map<String, List<String>> roleToOnmsGroupMap) {
        this.roleToOnmsGroupMap = roleToOnmsGroupMap;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean shouldFilter = AclUtils.shouldFilter(SecurityContextHolder.getContext().getAuthentication().getAuthorities());
        ArrayList groups = new ArrayList();
        if (shouldFilter) {
            for (String role : this.roleToOnmsGroupMap.keySet()) {
                LOG.debug("found role: {}, associated with user group: {}", (Object)role, this.roleToOnmsGroupMap.get(role));
                if (!this.userHasAuthority(role)) continue;
                groups.addAll(this.roleToOnmsGroupMap.get(role));
            }
            if (groups.isEmpty()) {
                shouldFilter = false;
            }
        }
        try {
            if (shouldFilter) {
                String[] groupNames = new String[groups.size()];
                for (int i = 0; i < groups.size(); ++i) {
                    groupNames[i] = (String)groups.get(i);
                }
                this.m_filterManager.enableAuthorizationFilter(groupNames);
            }
            chain.doFilter(request, response);
        }
        finally {
            if (shouldFilter) {
                this.m_filterManager.disableAuthorizationFilter();
            }
        }
    }

    private boolean userHasAuthority(String role) {
        for (GrantedAuthority authority : SecurityContextHolder.getContext().getAuthentication().getAuthorities()) {
            LOG.debug("checking role: {}, with granted authority: {}", (Object)role, (Object)authority.getAuthority());
            if (!authority.getAuthority().equals(role)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

