/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.web.springframework.security.AclUtils;
import org.opennms.web.springframework.security.OnmsAuthenticationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthFilterEnabler
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFilterEnabler.class);
    private FilterManager m_filterManager;
    private GroupDao m_groupDao;

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.m_groupDao = groupDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean shouldFilter = AclUtils.shouldFilter(SecurityContextHolder.getContext().getAuthentication().getAuthorities());
        try {
            if (shouldFilter) {
                OnmsAuthenticationDetails details;
                String user = SecurityContextHolder.getContext().getAuthentication().getName();
                LOG.debug("Applying ACL filter for user: {}", (Object)user);
                List groups = this.m_groupDao.findGroupsForUser(user);
                Object[] groupNames = new String[groups.size()];
                for (int i = 0; i < groups.size(); ++i) {
                    groupNames[i] = ((Group)groups.get(i)).getName();
                }
                LOG.debug("Found groups for user {}: {}", (Object)user, (Object)Arrays.toString(groupNames));
                if (SecurityContextHolder.getContext().getAuthentication().getDetails() instanceof OnmsAuthenticationDetails && (details = (OnmsAuthenticationDetails)((Object)SecurityContextHolder.getContext().getAuthentication().getDetails())).getUserGroups() != null && details.getUserGroups().length > 0) {
                    HashSet<String> detailsSet = new HashSet<String>(Arrays.asList(details.getUserGroups()));
                    HashSet<Object> groupSet = new HashSet<Object>(Arrays.asList(groupNames));
                    if (groupSet.containsAll(detailsSet)) {
                        groupNames = details.getUserGroups();
                    }
                }
                LOG.debug("Enabling authorization filter for user {} with groups: {}", (Object)user, (Object)Arrays.toString(groupNames));
                this.m_filterManager.enableAuthorizationFilter((String[])groupNames);
            }
            chain.doFilter(request, response);
        }
        finally {
            if (shouldFilter) {
                this.m_filterManager.disableAuthorizationFilter();
            }
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

