/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka.shell;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="opennms", name="kafka-ipc-topics", description="Show status of all Kafka IPC topics.")
@Service
public class KafkaIpcTopics
implements Action {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final String STATUS_OK = "[OK]";
    private static final String STATUS_MISSING = "[MISSING]";
    private static final String STATUS_NOT_CONFIGURED = "[NOT CONFIGURED]";
    private static final String REQUIRED_SINK_MODULE = "Heartbeat";
    private static final List<String> OPTIONAL_SINK_MODULES = List.of("Events", "Syslog", "Trap", "DeviceConfig");
    private static final String TELEMETRY_MODULE_PREFIX = "Telemetry-";
    private static final List<String> KNOWN_TELEMETRY_QUEUES = List.of("Netflow-5", "Netflow-9", "IPFIX", "SFlow", "JTI", "NXOS", "BMP", "OpenConfig", "Graphite");
    @Reference
    private Identity identity;
    @Reference
    private ConfigurationAdmin configAdmin;
    @Reference(optional=true)
    private MonitoringLocationDao monitoringLocationDao;
    @Option(name="-t", aliases={"--timeout"}, description="Connection timeout for Kafka Server (ms)")
    private int timeout;

    public Object execute() throws Exception {
        Set existingTopics;
        Properties kafkaConfig = Utils.getKafkaConfig((Identity)this.identity, (ConfigurationAdmin)this.configAdmin, (String)"rpc");
        if (kafkaConfig.isEmpty() || kafkaConfig.getProperty("bootstrap.servers") == null) {
            System.out.println("Kafka not configured (bootstrap.servers not set)");
            return null;
        }
        if (this.timeout <= 0) {
            String requestTimeoutMsConfig = kafkaConfig.getProperty("request.timeout.ms");
            this.timeout = !Strings.isNullOrEmpty((String)requestTimeoutMsConfig) ? Integer.parseInt(requestTimeoutMsConfig) : 5000;
        }
        kafkaConfig.put("request.timeout.ms", (Object)this.timeout);
        System.out.println("\nKafka IPC Topics Status");
        System.out.println("=======================\n");
        System.out.println("Kafka Connectivity:");
        try {
            existingTopics = Utils.getTopics((Properties)kafkaConfig);
            System.out.printf("  %-60s %s%n", "Connecting to Kafka", STATUS_OK);
        }
        catch (Exception e) {
            System.out.printf("  %-60s %s%n", "Connecting to Kafka", STATUS_MISSING);
            System.out.println("  Error: " + e.getMessage());
            return null;
        }
        System.out.println();
        String instanceId = SystemInfoUtils.getInstanceId();
        List<String> locations = this.getLocations();
        int totalMissing = 0;
        totalMissing += this.printRpcTopics(existingTopics, instanceId, locations);
        totalMissing += this.printSinkTopics(existingTopics, instanceId);
        System.out.println();
        if ((totalMissing += this.printTwinTopics(existingTopics, instanceId, locations)) > 0) {
            System.out.println("Summary: " + totalMissing + " required topic(s) missing");
        } else {
            System.out.println("Summary: All required topics exist");
        }
        return null;
    }

    private List<String> getLocations() {
        List<String> locations = new ArrayList<String>();
        if (this.monitoringLocationDao != null) {
            try {
                List allLocations = this.monitoringLocationDao.findAll();
                locations = allLocations.stream().map(OnmsMonitoringLocation::getLocationName).sorted().collect(Collectors.toList());
            }
            catch (Exception e) {
                System.out.println("Warning: Could not query locations: " + e.getMessage());
            }
        }
        if (locations.isEmpty()) {
            locations.add(this.identity.getLocation());
        }
        return locations;
    }

    private int printRpcTopics(Set<String> existingTopics, String instanceId, List<String> locations) {
        int missingCount = 0;
        System.out.println("RPC Topics (required):");
        String responseTopic = instanceId + ".rpc-response";
        boolean responseExists = existingTopics.contains(responseTopic);
        this.printRequiredTopicLine(responseTopic, responseExists);
        if (!responseExists) {
            ++missingCount;
        }
        System.out.println();
        System.out.println("RPC Topics (per-location - required):");
        for (String location : locations) {
            if ("Default".equals(location)) continue;
            String topic = instanceId + "." + location + ".rpc-request";
            boolean exists = existingTopics.contains(topic);
            this.printRequiredTopicLine(topic, exists);
            if (exists) continue;
            ++missingCount;
        }
        System.out.println();
        return missingCount;
    }

    private int printSinkTopics(Set<String> existingTopics, String instanceId) {
        int missingCount = 0;
        String sinkPrefix = instanceId + ".Sink.";
        System.out.println("Sink Topics (required):");
        String heartbeatTopic = sinkPrefix + REQUIRED_SINK_MODULE;
        boolean heartbeatExists = existingTopics.contains(heartbeatTopic);
        this.printRequiredTopicLine(heartbeatTopic, heartbeatExists);
        if (!heartbeatExists) {
            ++missingCount;
        }
        System.out.println();
        System.out.println("Sink Topics (optional - feature dependent):");
        for (String moduleId : OPTIONAL_SINK_MODULES) {
            String topic = sinkPrefix + moduleId;
            boolean exists = existingTopics.contains(topic);
            this.printOptionalTopicLine(topic, exists);
        }
        System.out.println();
        System.out.println("Sink Topics (telemetry - optional):");
        System.out.println("  Note: These are default queue names, if queue names were customized in");
        System.out.println("        telemetryd-configuration.xml, below topics may differ");
        String telemetryPrefix = sinkPrefix + TELEMETRY_MODULE_PREFIX;
        for (String queueName : KNOWN_TELEMETRY_QUEUES) {
            String topic = telemetryPrefix + queueName;
            boolean exists = existingTopics.contains(topic);
            this.printOptionalTopicLine(topic, exists);
        }
        existingTopics.stream().filter(t -> t.startsWith(telemetryPrefix)).filter(t -> KNOWN_TELEMETRY_QUEUES.stream().noneMatch(q -> t.equals(telemetryPrefix + q))).sorted().forEach(t -> this.printOptionalTopicLine((String)t, true));
        System.out.println();
        return missingCount;
    }

    private int printTwinTopics(Set<String> existingTopics, String instanceId, List<String> locations) {
        int missingCount = 0;
        System.out.println("Twin Topics (required):");
        String twinRequest = instanceId + ".twin.request";
        String twinResponse = instanceId + ".twin.response";
        boolean requestExists = existingTopics.contains(twinRequest);
        boolean responseExists = existingTopics.contains(twinResponse);
        this.printRequiredTopicLine(twinRequest, requestExists);
        this.printRequiredTopicLine(twinResponse, responseExists);
        if (!requestExists) {
            ++missingCount;
        }
        if (!responseExists) {
            ++missingCount;
        }
        System.out.println();
        System.out.println("Twin Topics (per-location - required):");
        for (String location : locations) {
            if ("Default".equals(location)) continue;
            String topic = instanceId + ".twin.response." + location;
            boolean exists = existingTopics.contains(topic);
            this.printRequiredTopicLine(topic, exists);
            if (exists) continue;
            ++missingCount;
        }
        return missingCount;
    }

    private void printRequiredTopicLine(String topic, boolean exists) {
        String status = exists ? STATUS_OK : STATUS_MISSING;
        System.out.printf("  %-60s %s%n", topic, status);
    }

    private void printOptionalTopicLine(String topic, boolean exists) {
        String status = exists ? STATUS_OK : STATUS_NOT_CONFIGURED;
        System.out.printf("  %-60s %s%n", topic, status);
    }
}

