/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider.symmetric;

import java.util.HashMap;
import org.opennms.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.engines.SkipjackEngine;
import org.opennms.shaded.org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.opennms.shaded.org.bouncycastle.crypto.macs.CFBBlockCipherMac;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEBlockCipher;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEKeyGenerator;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEMac;
import org.opennms.shaded.org.bouncycastle.jce.provider.JDKAlgorithmParameters;

public final class Skipjack {
    private Skipjack() {
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "Skipjack IV";
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new SkipjackEngine());
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("Skipjack", 80, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends JCEMac {
        public Mac() {
            super(new CBCBlockCipherMac(new SkipjackEngine()));
        }
    }

    public static class MacCFB8
    extends JCEMac {
        public MacCFB8() {
            super(new CFBBlockCipherMac(new SkipjackEngine()));
        }
    }

    public static class Mappings
    extends HashMap {
        public Mappings() {
            this.put("Cipher.SKIPJACK", "org.opennms.shaded.org.bouncycastle.jce.provider.symmetric.Skipjack$ECB");
            this.put("KeyGenerator.SKIPJACK", "org.opennms.shaded.org.bouncycastle.jce.provider.symmetric.Skipjack$KeyGen");
            this.put("AlgorithmParameters.SKIPJACK", "org.opennms.shaded.org.bouncycastle.jce.provider.symmetric.Skipjack$AlgParams");
            this.put("Mac.SKIPJACKMAC", "org.opennms.shaded.org.bouncycastle.jce.provider.symmetric.Skipjack$Mac");
            this.put("Alg.Alias.Mac.SKIPJACK", "SKIPJACKMAC");
            this.put("Mac.SKIPJACKMAC/CFB8", "org.opennms.shaded.org.bouncycastle.jce.provider.symmetric.Skipjack$MacCFB8");
            this.put("Alg.Alias.Mac.SKIPJACK/CFB8", "SKIPJACKMAC/CFB8");
        }
    }
}

