/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1OutputStream;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Set;
import org.opennms.shaded.org.bouncycastle.asn1.BERConstructedOctetString;
import org.opennms.shaded.org.bouncycastle.asn1.BEROutputStream;
import org.opennms.shaded.org.bouncycastle.asn1.BERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.DEREncodable;
import org.opennms.shaded.org.bouncycastle.asn1.DEROutputStream;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int n, DEREncodable dEREncodable) {
        super(n, dEREncodable);
    }

    public BERTaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        super(bl, n, dEREncodable);
    }

    public BERTaggedObject(int n) {
        super(false, n, new BERSequence());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.writeTag(160, this.tagNo);
            dEROutputStream.write(128);
            if (!this.empty) {
                if (!this.explicit) {
                    Enumeration enumeration;
                    if (this.obj instanceof ASN1OctetString) {
                        if (this.obj instanceof BERConstructedOctetString) {
                            enumeration = ((BERConstructedOctetString)this.obj).getObjects();
                        } else {
                            ASN1OctetString aSN1OctetString = (ASN1OctetString)this.obj;
                            BERConstructedOctetString bERConstructedOctetString = new BERConstructedOctetString(aSN1OctetString.getOctets());
                            enumeration = bERConstructedOctetString.getObjects();
                        }
                    } else if (this.obj instanceof ASN1Sequence) {
                        enumeration = ((ASN1Sequence)this.obj).getObjects();
                    } else if (this.obj instanceof ASN1Set) {
                        enumeration = ((ASN1Set)this.obj).getObjects();
                    } else {
                        throw new RuntimeException("not implemented: " + this.obj.getClass().getName());
                    }
                    while (enumeration.hasMoreElements()) {
                        dEROutputStream.writeObject(enumeration.nextElement());
                    }
                } else {
                    dEROutputStream.writeObject(this.obj);
                }
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
        } else {
            super.encode(dEROutputStream);
        }
    }
}

