/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.tls;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import net.jradius.tls.Certificate;
import net.jradius.tls.CertificateVerifyer;
import net.jradius.tls.SecurityParameters;
import net.jradius.tls.TlsDSSSigner;
import net.jradius.tls.TlsKeyExchange;
import net.jradius.tls.TlsProtocolHandler;
import net.jradius.tls.TlsRSASigner;
import net.jradius.tls.TlsSigner;
import net.jradius.tls.TlsUtils;
import org.opennms.shaded.org.bouncycastle.asn1.DERBitString;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.x509.KeyUsage;
import org.opennms.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509Extension;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509Extensions;
import org.opennms.shaded.org.bouncycastle.crypto.CryptoException;
import org.opennms.shaded.org.bouncycastle.crypto.Signer;
import org.opennms.shaded.org.bouncycastle.crypto.agreement.srp.SRP6Client;
import org.opennms.shaded.org.bouncycastle.crypto.agreement.srp.SRP6Util;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA1Digest;
import org.opennms.shaded.org.bouncycastle.crypto.io.SignerInputStream;
import org.opennms.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.util.PublicKeyFactory;
import org.opennms.shaded.org.bouncycastle.util.BigIntegers;

class TlsSRPKeyExchange
implements TlsKeyExchange {
    private TlsProtocolHandler handler;
    private CertificateVerifyer verifyer;
    private short keyExchange;
    private TlsSigner tlsSigner;
    private AsymmetricKeyParameter serverPublicKey = null;
    private byte[] SRP_identity = null;
    private byte[] SRP_password = null;
    private byte[] s = null;
    private BigInteger B = null;
    private SRP6Client srpClient = new SRP6Client();

    TlsSRPKeyExchange(TlsProtocolHandler handler, CertificateVerifyer verifyer, short keyExchange) {
        switch (keyExchange) {
            case 10: {
                this.tlsSigner = null;
                break;
            }
            case 12: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 11: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.handler = handler;
        this.verifyer = verifyer;
        this.keyExchange = keyExchange;
    }

    public void skipServerCertificate() throws IOException {
        if (this.tlsSigner != null) {
            this.handler.failWithError((short)2, (short)10);
        }
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.tlsSigner == null) {
            this.handler.failWithError((short)2, (short)10);
        }
        X509CertificateStructure x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            this.handler.failWithError((short)2, (short)43);
        }
        if (this.serverPublicKey.isPrivate()) {
            this.handler.failWithError((short)2, (short)80);
        }
        switch (this.keyExchange) {
            case 12: {
                if (!(this.serverPublicKey instanceof RSAKeyParameters)) {
                    this.handler.failWithError((short)2, (short)46);
                }
                this.validateKeyUsage(x509Cert, 128);
                break;
            }
            case 11: {
                if (this.serverPublicKey instanceof DSAPublicKeyParameters) break;
                this.handler.failWithError((short)2, (short)46);
                break;
            }
            default: {
                this.handler.failWithError((short)2, (short)43);
            }
        }
        if (!this.verifyer.isValid(serverCertificate.getCerts())) {
            this.handler.failWithError((short)2, (short)90);
        }
    }

    public void skipServerKeyExchange() throws IOException {
        this.handler.failWithError((short)2, (short)10);
    }

    public void processServerKeyExchange(InputStream is, SecurityParameters securityParameters) throws IOException {
        byte[] sigByte;
        InputStream sigIn = is;
        Signer signer = null;
        if (this.tlsSigner != null) {
            signer = this.initSigner(this.tlsSigner, securityParameters);
            sigIn = new SignerInputStream(is, signer);
        }
        byte[] NBytes = TlsUtils.readOpaque16(sigIn);
        byte[] gBytes = TlsUtils.readOpaque16(sigIn);
        byte[] sBytes = TlsUtils.readOpaque8(sigIn);
        byte[] BBytes = TlsUtils.readOpaque16(sigIn);
        if (signer != null && !signer.verifySignature(sigByte = TlsUtils.readOpaque16(is))) {
            this.handler.failWithError((short)2, (short)42);
        }
        BigInteger N = new BigInteger(1, NBytes);
        BigInteger g = new BigInteger(1, gBytes);
        this.s = sBytes;
        try {
            this.B = SRP6Util.validatePublicValue(N, new BigInteger(1, BBytes));
        }
        catch (CryptoException e) {
            this.handler.failWithError((short)2, (short)47);
        }
        this.srpClient.init(N, g, new SHA1Digest(), this.handler.getRandom());
    }

    public byte[] generateClientKeyExchange() throws IOException {
        return BigIntegers.asUnsignedByteArray(this.srpClient.generateClientCredentials(this.s, this.SRP_identity, this.SRP_password));
    }

    public byte[] generatePremasterSecret() throws IOException {
        try {
            return BigIntegers.asUnsignedByteArray(this.srpClient.calculateSecret(this.B));
        }
        catch (CryptoException e) {
            this.handler.failWithError((short)2, (short)47);
            return null;
        }
    }

    private void validateKeyUsage(X509CertificateStructure c, int keyUsageBits) throws IOException {
        DERBitString ku;
        int bits;
        X509Extension ext;
        X509Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension((DERObjectIdentifier)X509Extensions.KeyUsage)) != null && ((bits = (ku = KeyUsage.getInstance(ext)).getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            this.handler.failWithError((short)2, (short)46);
        }
    }

    private Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

