/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.pool;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslog;
import org.graylog2.syslog4j.impl.AbstractSyslogConfigIF;
import org.graylog2.syslog4j.impl.AbstractSyslogWriter;

public abstract class AbstractSyslogPoolFactory
extends BasePoolableObjectFactory {
    private static final long serialVersionUID = -7441569603980981508L;
    protected AbstractSyslog syslog = null;
    protected AbstractSyslogConfigIF syslogConfig = null;
    protected ObjectPool pool = null;

    public void initialize(AbstractSyslog abstractSyslog) throws SyslogRuntimeException {
        this.syslog = abstractSyslog;
        try {
            this.syslogConfig = (AbstractSyslogConfigIF)this.syslog.getConfig();
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must implement AbstractSyslogConfigIF");
        }
        this.pool = this.createPool();
    }

    public Object makeObject() throws Exception {
        AbstractSyslogWriter syslogWriter = this.syslog.createWriter();
        if (this.syslogConfig.isThreaded()) {
            this.syslog.createWriterThread(syslogWriter);
        }
        return syslogWriter;
    }

    public void destroyObject(Object obj) throws Exception {
        AbstractSyslogWriter writer = (AbstractSyslogWriter)obj;
        writer.shutdown();
        super.destroyObject((Object)writer);
    }

    public abstract ObjectPool createPool() throws SyslogRuntimeException;

    public AbstractSyslogWriter borrowSyslogWriter() throws Exception {
        AbstractSyslogWriter syslogWriter = (AbstractSyslogWriter)this.pool.borrowObject();
        return syslogWriter;
    }

    public void returnSyslogWriter(AbstractSyslogWriter syslogWriter) throws Exception {
        this.pool.returnObject((Object)syslogWriter);
    }

    public void clear() throws Exception {
        this.pool.clear();
    }

    public void close() throws Exception {
        this.pool.close();
    }
}

