/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.NamespaceWatchedEvent;
import org.apache.curator.utils.ThreadUtils;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class NamespaceWatcher
implements Watcher,
Closeable {
    private volatile CuratorFrameworkImpl client;
    private volatile Watcher actualWatcher;
    private final String unfixedPath;
    private volatile CuratorWatcher curatorWatcher;

    NamespaceWatcher(CuratorFrameworkImpl client, Watcher actualWatcher, String unfixedPath) {
        this.client = client;
        this.actualWatcher = actualWatcher;
        this.unfixedPath = (String)Preconditions.checkNotNull((Object)unfixedPath, (Object)"unfixedPath cannot be null");
        this.curatorWatcher = null;
    }

    NamespaceWatcher(CuratorFrameworkImpl client, CuratorWatcher curatorWatcher, String unfixedPath) {
        this.client = client;
        this.actualWatcher = null;
        this.curatorWatcher = curatorWatcher;
        this.unfixedPath = (String)Preconditions.checkNotNull((Object)unfixedPath, (Object)"unfixedPath cannot be null");
    }

    String getUnfixedPath() {
        return this.unfixedPath;
    }

    @Override
    public void close() {
        this.client = null;
        this.actualWatcher = null;
        this.curatorWatcher = null;
    }

    public void process(WatchedEvent event) {
        if (this.client != null) {
            if (event.getType() != Watcher.Event.EventType.None && this.client.getWatcherRemovalManager() != null) {
                this.client.getWatcherRemovalManager().noteTriggeredWatcher(this);
            }
            if (this.actualWatcher != null) {
                this.actualWatcher.process((WatchedEvent)new NamespaceWatchedEvent(this.client, event));
            } else if (this.curatorWatcher != null) {
                try {
                    this.curatorWatcher.process(new NamespaceWatchedEvent(this.client, event));
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted((Throwable)e);
                    this.client.logError("Watcher exception", e);
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() == o.getClass()) {
            NamespaceWatcher watcher = (NamespaceWatcher)o;
            return Objects.equal((Object)this.unfixedPath, (Object)watcher.getUnfixedPath()) && Objects.equal((Object)this.actualWatcher, (Object)watcher.actualWatcher) && Objects.equal((Object)this.curatorWatcher, (Object)watcher.curatorWatcher);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.actualWatcher, this.unfixedPath, this.curatorWatcher});
    }
}

