/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.jmxconfig.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.FilterCriteria;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQueryException;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.QueryResult;

public class MBeanServerQuery {
    private List<FilterCriteria> ignoreFilterList = new ArrayList<FilterCriteria>();
    private List<FilterCriteria> filterCriteriaList = new ArrayList<FilterCriteria>();
    private boolean sort;
    private boolean fetchValues;
    private boolean showEmptyMbeans;

    public MBeanServerQuery withFilters(Collection<String> filterList) {
        if (filterList != null) {
            for (String eachFilter : filterList) {
                this.filterCriteriaList.add(FilterCriteria.parse(eachFilter));
            }
        }
        return this;
    }

    public MBeanServerQuery sort(boolean sortingFlag) {
        this.sort = sortingFlag;
        return this;
    }

    public MBeanServerQuery fetchValues(boolean fetchValuesFlag) {
        this.fetchValues = fetchValuesFlag;
        return this;
    }

    public MBeanServerQuery showMBeansWithoutAttributes(boolean all) {
        this.showEmptyMbeans = all;
        return this;
    }

    public MBeanServerQuery withIgnoresFilter(Collection<String> ignoreFilter) {
        if (ignoreFilter != null) {
            for (String eachFilter : ignoreFilter) {
                this.ignoreFilterList.add(FilterCriteria.parse(eachFilter));
            }
        }
        return this;
    }

    public QueryResult execute(MBeanServerConnection mbeanServerConnection) throws MBeanServerQueryException {
        try {
            if (this.filterCriteriaList.isEmpty()) {
                this.filterCriteriaList.add(new FilterCriteria());
            }
            QueryResult queryResult = MBeanServerQuery.executeQuery(this.filterCriteriaList, mbeanServerConnection);
            queryResult.setTotalMBeanCount(mbeanServerConnection.getMBeanCount());
            QueryResult ignoreResult = MBeanServerQuery.executeQuery(this.ignoreFilterList, mbeanServerConnection);
            for (QueryResult.MBeanResult eachResult : ignoreResult.getMBeanResults()) {
                for (MBeanAttributeInfo eachAttribute : eachResult.attributeResult.attributes) {
                    queryResult.remove(eachResult.objectName, eachAttribute);
                }
            }
            if (!this.showEmptyMbeans) {
                queryResult.removeEmptyMBeanResults();
            }
            if (this.sort) {
                queryResult.sort();
            }
            if (this.fetchValues) {
                for (QueryResult.MBeanResult eachMbeanResult : queryResult.getMBeanResults()) {
                    QueryResult.AttributeResult attributeResult = eachMbeanResult.attributeResult;
                    for (MBeanAttributeInfo eachAttribute : attributeResult.attributes) {
                        if (!eachAttribute.isReadable()) continue;
                        try {
                            Object value = mbeanServerConnection.getAttribute(eachMbeanResult.objectName, eachAttribute.getName());
                            attributeResult.setValue(eachAttribute, value);
                        }
                        catch (Exception uoe) {
                            attributeResult.setValue(eachAttribute, "ERROR: " + uoe.getMessage());
                        }
                    }
                }
            }
            return queryResult;
        }
        catch (IOException | JMException e) {
            throw new MBeanServerQueryException(e);
        }
    }

    private static QueryResult executeQuery(List<FilterCriteria> filterCriteriaList, MBeanServerConnection mbeanServerConnection) throws IOException, JMException {
        QueryResult result = new QueryResult();
        for (FilterCriteria eachFilterCriteria : filterCriteriaList) {
            ObjectName query = eachFilterCriteria.objectName != null ? new ObjectName(eachFilterCriteria.objectName) : null;
            Set<ObjectName> tmpObjectNames = mbeanServerConnection.queryNames(query, null);
            for (ObjectName eachObjectName : tmpObjectNames) {
                MBeanInfo mbeanInfo = mbeanServerConnection.getMBeanInfo(eachObjectName);
                result.put(eachObjectName, mbeanInfo);
                result.setAttributeTotalCount(eachObjectName, mbeanInfo.getAttributes().length);
                for (MBeanAttributeInfo eachAttribute : mbeanInfo.getAttributes()) {
                    if (!eachFilterCriteria.matches(eachAttribute)) continue;
                    result.put(eachObjectName, eachAttribute);
                }
            }
        }
        return result;
    }
}

