/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class Dot1qTpFdbTableTracker
extends TableTracker {
    public static final SnmpObjId DOT1Q_TP_FDB_ADDRESS_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.7.1.2.2.1.1");
    public static final SnmpObjId DOT1Q_TP_FDB_PORT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.7.1.2.2.1.2");
    public static final SnmpObjId DOT1Q_TP_FDB_STATUS_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.7.1.2.2.1.3");
    public static final String DOT1Q_TP_FDB_ADDRESS = "dot1qTpFdbAddress";
    public static final String DOT1Q_TP_FDB_PORT = "dot1qTpFdbPort";
    public static final String DOT1Q_TP_FDB_STATUS = "dot1qTpFdbStatus";
    public static SnmpObjId[] ms_elemList = new SnmpObjId[]{DOT1Q_TP_FDB_PORT_OID, DOT1Q_TP_FDB_STATUS_OID};

    public Dot1qTpFdbTableTracker() {
        super(ms_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new Dot1qTpFdbRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processDot1qTpFdbRow((Dot1qTpFdbRow)row);
    }

    public void processDot1qTpFdbRow(Dot1qTpFdbRow row) {
        System.out.printf("\t\t%s (%s)= %s (this is extracted from table index)\n", String.valueOf(DOT1Q_TP_FDB_ADDRESS_OID) + "." + row.getInstance().toString(), DOT1Q_TP_FDB_ADDRESS, row.getDot1qTpFdbAddress());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(DOT1Q_TP_FDB_PORT_OID) + "." + row.getInstance().toString(), DOT1Q_TP_FDB_PORT, row.getDot1qTpFdbPort());
        System.out.printf("\t\t%s (%s)= %s (%s)\n", String.valueOf(DOT1Q_TP_FDB_STATUS_OID) + "." + row.getInstance().toString(), DOT1Q_TP_FDB_STATUS, row.getDot1qTpFdbStatus(), BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.get((Integer)row.getDot1qTpFdbStatus()));
    }

    public static class Dot1qTpFdbRow
    extends SnmpRowResult {
        public Dot1qTpFdbRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public String getDot1qTpFdbAddress() {
            int[] identifiers = this.getInstance().getIds();
            if (identifiers.length != 7) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = identifiers.length - 6; i < identifiers.length; ++i) {
                if (identifiers[i] >= 16) {
                    sb.append(Integer.toHexString(identifiers[i]));
                    continue;
                }
                sb.append("0").append(Integer.toHexString(identifiers[i]));
            }
            return sb.toString();
        }

        public Integer getDot1qTpFdbPort() {
            if (this.getValue(DOT1Q_TP_FDB_PORT_OID) != null) {
                return this.getValue(DOT1Q_TP_FDB_PORT_OID).toInt();
            }
            return null;
        }

        public Integer getDot1qTpFdbStatus() {
            if (this.getValue(DOT1Q_TP_FDB_STATUS_OID) != null) {
                return this.getValue(DOT1Q_TP_FDB_STATUS_OID).toInt();
            }
            return null;
        }

        public BridgeForwardingTableEntry getLink() {
            BridgeForwardingTableEntry link = new BridgeForwardingTableEntry();
            link.setBridgePort(this.getDot1qTpFdbPort());
            link.setMacAddress(this.getDot1qTpFdbAddress());
            if (this.getDot1qTpFdbStatus() != null) {
                link.setBridgeDot1qTpFdbStatus(BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.get((Integer)this.getDot1qTpFdbStatus()));
            }
            return link;
        }
    }
}

