/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.nrtbroker.local.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opennms.nrtg.api.NrtBroker;
import org.opennms.nrtg.api.ProtocolCollector;
import org.opennms.nrtg.api.model.CollectionJob;
import org.opennms.nrtg.api.model.MeasurementSet;
import org.opennms.nrtg.nrtbroker.local.internal.NrtBrokerLocalMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NrtBrokerLocal
implements NrtBroker,
NrtBrokerLocalMBean {
    private static Logger logger = LoggerFactory.getLogger(NrtBrokerLocal.class);
    private List<ProtocolCollector> m_protocolCollectors;
    private TimedOutMap m_measurementSets = new TimedOutMap();

    public void publishCollectionJob(CollectionJob collectionJob) {
        ProtocolCollector protocolCollector = this.getProtocolCollector(collectionJob.getService());
        if (protocolCollector != null) {
            collectionJob = protocolCollector.collect(collectionJob);
            collectionJob.setFinishedTimestamp(new Date());
            this.m_measurementSets.addMeasurementSets(collectionJob.getMeasurementSetsByDestination());
        } else {
            logger.warn("Cannot find collector for protocol {}", (Object)collectionJob.getService());
        }
    }

    public List<MeasurementSet> receiveMeasurementSets(String destination) {
        return this.m_measurementSets.getAndRemove(destination);
    }

    public ProtocolCollector getProtocolCollector(String protocol) {
        for (ProtocolCollector protocolCollector : this.m_protocolCollectors) {
            if (!protocolCollector.getProtcol().equals(protocol)) continue;
            return protocolCollector;
        }
        return null;
    }

    public void setProtocolCollectors(List<ProtocolCollector> protocolCollectors) {
        this.m_protocolCollectors = protocolCollectors;
    }

    public List<ProtocolCollector> getProtocolCollectors() {
        return this.m_protocolCollectors;
    }

    @Override
    public Integer getMeasurementSetSize() {
        return this.m_measurementSets.getAmountOfMeasurementSets();
    }

    private static class TimedOutMap {
        private Map<String, List<MeasurementSet>> m_measurementSets = new HashMap<String, List<MeasurementSet>>();
        private Map<String, Date> m_lastAccess = new HashMap<String, Date>();

        private TimedOutMap() {
        }

        public synchronized List<MeasurementSet> getAndRemove(String key) {
            this.m_lastAccess.put(key, new Date());
            List<MeasurementSet> measurementSetList = this.m_measurementSets.get(key);
            this.m_measurementSets.put(key, new ArrayList());
            return measurementSetList;
        }

        public synchronized void addMeasurementSets(Map<String, MeasurementSet> measurementSets) {
            for (Map.Entry<String, MeasurementSet> entry : measurementSets.entrySet()) {
                String[] arr;
                for (String destination : arr = entry.getKey().split(",")) {
                    this.addMeasurementSet(destination.trim(), entry.getValue());
                }
            }
            this.doHousekeeping();
        }

        public synchronized void addMeasurementSet(String key, MeasurementSet measurementSet) {
            if (!this.m_measurementSets.containsKey(key)) {
                this.m_measurementSets.put(key, new ArrayList());
            }
            List<MeasurementSet> measurementSetList = this.m_measurementSets.get(key);
            measurementSetList.add(measurementSet);
        }

        private synchronized void doHousekeeping() {
            Iterator<Map.Entry<String, Date>> it = this.m_lastAccess.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Date> entry = it.next();
                Date lastAccess = entry.getValue();
                Date now = new Date();
                if (now.getTime() - lastAccess.getTime() <= 120000L) continue;
                it.remove();
                this.m_measurementSets.remove(entry.getKey());
                logger.warn("Timed out object removed '{}'", (Object)entry.getKey());
            }
        }

        private synchronized Integer getAmountOfMeasurementSets() {
            return this.m_measurementSets.size();
        }
    }
}

