/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.features;

import com.atlassian.sal.api.features.FeatureKeyScope;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EnabledDarkFeatures {
    public static final EnabledDarkFeatures NONE = new EnabledDarkFeatures(ImmutableMap.of());
    private final ImmutableMap<FeatureKeyScope, ImmutableSet<String>> enabledFeatures;

    public EnabledDarkFeatures(ImmutableMap<FeatureKeyScope, ImmutableSet<String>> enabledFeatures) {
        Preconditions.checkNotNull(enabledFeatures, "enabledFeatures");
        this.enabledFeatures = ImmutableMap.copyOf(enabledFeatures);
    }

    public ImmutableSet<String> getFeatureKeys() {
        return ImmutableSet.copyOf(Iterables.concat(this.enabledFeatures.values()));
    }

    public ImmutableSet<String> getFeatureKeys(Predicate<FeatureKeyScope> criteria) {
        Preconditions.checkNotNull(criteria, "criteria");
        return ImmutableSet.copyOf(Iterables.concat(Maps.filterKeys(this.enabledFeatures, criteria).values()));
    }

    public boolean isFeatureEnabled(String featureKey) {
        Preconditions.checkNotNull(featureKey, "featureKey");
        return Iterables.contains(Iterables.concat(this.enabledFeatures.values()), featureKey);
    }

    public String toString() {
        return "EnabledDarkFeatures{enabledFeatures=" + this.enabledFeatures + '}';
    }
}

