/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json.gen;

import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.PropertyInput;
import com.atlassian.jira.rest.client.internal.json.gen.ComplexIssueInputFieldValueJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class IssueInputJsonGenerator
implements JsonGenerator<IssueInput> {
    private final ComplexIssueInputFieldValueJsonGenerator complexIssueInputFieldValueJsonGenerator = new ComplexIssueInputFieldValueJsonGenerator();

    @Override
    public JSONObject generate(IssueInput issue) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        JSONObject fields = new JSONObject();
        if (issue != null && issue.getFields() != null) {
            for (FieldInput field : issue.getFields().values()) {
                if (field.getValue() == null) continue;
                fields.put(field.getId(), this.complexIssueInputFieldValueJsonGenerator.generateFieldValueForJson(field.getValue()));
            }
        }
        jsonObject.put("fields", fields);
        JSONArray entityProperties = new JSONArray();
        if (issue != null && issue.getProperties() != null) {
            for (PropertyInput p : issue.getProperties()) {
                JSONObject property = new JSONObject();
                property.put("key", p.getKey());
                property.put("value", new JSONObject(p.getValue()));
                entityProperties.put(property);
            }
        }
        jsonObject.put("properties", entityProperties);
        return jsonObject;
    }
}

