/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.ServiceConfiguration;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class ServiceConfig1701MigratorOffline
extends AbstractOnmsUpgrade {
    private File configFile;
    private final List<String> oldServices = Arrays.asList(":Name=HttpAdaptor", ":Name=HttpAdaptorMgmt", ":Name=XSLTProcessor", "OpenNMS:Name=AccessPointMonitor", "OpenNMS:Name=Capsd", "OpenNMS:Name=Importer", "OpenNMS:Name=Linkd", "OpenNMS:Name=Threshd", "OpenNMS:Name=XmlrpcProvisioner", "OpenNMS:Name=Xmlrpcd");

    public ServiceConfig1701MigratorOffline() throws OnmsUpgradeException {
        try {
            this.configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SERVICE_CONF_FILE_NAME);
        }
        catch (IOException e) {
            throw new OnmsUpgradeException("Can't find Services Configuration file", e);
        }
    }

    @Override
    public int getOrder() {
        return 7;
    }

    @Override
    public String getDescription() {
        return "Fixes service-configuration.xml if necessary when upgrading from 1.12: NMS-6970";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        try {
            this.log("Backing up %s\n", this.configFile);
            this.zipFile(this.configFile);
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't backup service-configurations.xml because " + e.getMessage());
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        if (zip.exists()) {
            this.log("Removing backup %s\n", zip);
            FileUtils.deleteQuietly((File)zip);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        this.log("Restoring backup %s\n", this.configFile);
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        FileUtils.deleteQuietly((File)this.configFile);
        this.unzipFile(zip, zip.getParentFile());
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        try {
            ServiceConfiguration currentCfg = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (File)this.configFile);
            this.log("Current configuration: " + currentCfg.getServices().size() + " services.\n", new Object[0]);
            for (int i = currentCfg.getServices().size() - 1; i >= 0; --i) {
                Service localSvc = (Service)currentCfg.getServices().get(i);
                String name = localSvc.getName();
                if (!this.oldServices.contains(name)) continue;
                this.log("Removing old service %s\n", name);
                currentCfg.getServices().remove(i);
            }
            this.log("New configuration: " + currentCfg.getServices().size() + " services.\n", new Object[0]);
            StringWriter sw = new StringWriter();
            sw.write("<?xml version=\"1.0\"?>\n");
            sw.write("<!-- NOTE!!!!!!!!!!!!!!!!!!!\n");
            sw.write("The order in which these services are specified is important - for example, Eventd\n");
            sw.write("will need to come up last so that none of the event topic subcribers loose any event.\n");
            sw.write("\nWhen splitting services to run on mutiple VMs, the order of the services should be\n");
            sw.write("maintained\n");
            sw.write("-->\n");
            JaxbUtils.marshal((Object)currentCfg, (Writer)sw);
            FileWriter fw = new FileWriter(this.configFile);
            fw.write(sw.toString());
            fw.close();
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't fix services configuration because " + e.getMessage(), e);
        }
    }
}

