/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import java.time.Duration;

public class BulkheadConfig {
    public static final int DEFAULT_MAX_CONCURRENT_CALLS = 25;
    public static final Duration DEFAULT_MAX_WAIT_DURATION = Duration.ofSeconds(0L);
    private int maxConcurrentCalls = 25;
    private Duration maxWaitDuration = DEFAULT_MAX_WAIT_DURATION;

    private BulkheadConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(BulkheadConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static BulkheadConfig ofDefaults() {
        return new Builder().build();
    }

    public int getMaxConcurrentCalls() {
        return this.maxConcurrentCalls;
    }

    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public static class Builder {
        private BulkheadConfig config = new BulkheadConfig();

        public Builder() {
        }

        public Builder(BulkheadConfig bulkheadConfig) {
            this.config = bulkheadConfig;
        }

        public Builder maxConcurrentCalls(int maxConcurrentCalls) {
            if (maxConcurrentCalls < 0) {
                throw new IllegalArgumentException("maxConcurrentCalls must be an integer value >= 0");
            }
            this.config.maxConcurrentCalls = maxConcurrentCalls;
            return this;
        }

        public Builder maxWaitDuration(Duration maxWaitDuration) {
            if (maxWaitDuration.toMillis() < 0L) {
                throw new IllegalArgumentException("maxWaitDuration must be a positive integer value >= 0");
            }
            this.config.maxWaitDuration = maxWaitDuration;
            return this;
        }

        public BulkheadConfig build() {
            return this.config;
        }
    }
}

