/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class ImmutableElement {
    protected final Map<String, Object> properties;

    protected ImmutableElement(Map<String, Object> properties) {
        Objects.requireNonNull(properties);
        this.properties = Collections.unmodifiableMap(properties);
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public <T> T getProperty(String key, T defaultValue) {
        return (T)this.properties.getOrDefault(key, defaultValue);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableElement that = (ImmutableElement)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return "ImmutableElement{properties=" + this.properties + "}";
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder> {
        protected final Map<String, Object> properties = new HashMap<String, Object>();

        protected AbstractBuilder() {
        }

        public T property(String name, Object value) {
            if (name == null || value == null) {
                return (T)this;
            }
            this.properties.put(name, value);
            return (T)this;
        }

        public T properties(Map<String, Object> properties) {
            Objects.requireNonNull(properties, "properties cannot be null");
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.property(entry.getKey(), entry.getValue());
            }
            return (T)this;
        }
    }
}

