/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.services;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.geolocation.api.AddressInfo;
import org.opennms.features.geolocation.api.Coordinates;
import org.opennms.features.geolocation.api.GeolocationInfo;
import org.opennms.features.geolocation.api.GeolocationQuery;
import org.opennms.features.geolocation.api.GeolocationService;
import org.opennms.features.geolocation.api.NodeInfo;
import org.opennms.features.geolocation.api.SeverityInfo;
import org.opennms.features.status.api.node.NodeStatusCalculator;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculationStrategy;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculatorConfig;
import org.opennms.features.status.api.node.strategy.Status;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;

public class DefaultGeolocationService
implements GeolocationService {
    private GenericPersistenceAccessor genericPersistenceAccessor;
    private NodeStatusCalculator nodeStatusCalculator;

    public DefaultGeolocationService(GenericPersistenceAccessor genericPersistenceAccessor, NodeStatusCalculator nodeStatusCalculator) {
        this.genericPersistenceAccessor = Objects.requireNonNull(genericPersistenceAccessor);
        this.nodeStatusCalculator = Objects.requireNonNull(nodeStatusCalculator);
    }

    public List<GeolocationInfo> getLocations(GeolocationQuery query) {
        if (query == null) {
            return new ArrayList<GeolocationInfo>();
        }
        List<OnmsNode> nodes = this.getNodes(query);
        List<GeolocationInfo> nodesWithCoordinates = nodes.stream().filter(n -> DefaultGeolocationService.geoLocation(n) != null && DefaultGeolocationService.geoLocation(n).getLongitude() != null && DefaultGeolocationService.geoLocation(n).getLatitude() != null).filter(n -> DefaultGeolocationService.geoLocation(n).getLatitude() != Double.NEGATIVE_INFINITY && DefaultGeolocationService.geoLocation(n).getLongitude() != Double.NEGATIVE_INFINITY).map(this::convert).collect(Collectors.toList());
        if (query.getStatusCalculationStrategy() != null) {
            this.applyStatus(query, nodesWithCoordinates);
        }
        if (query.getSeverity() != null) {
            OnmsSeverity severity = OnmsSeverity.get((int)query.getSeverity().getId());
            return nodesWithCoordinates.stream().filter(n -> severity.getId() <= n.getSeverityInfo().getId()).collect(Collectors.toList());
        }
        return nodesWithCoordinates;
    }

    private List<OnmsNode> getNodes(GeolocationQuery query) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).alias("assetRecord", "assetRecord").and(new Restriction[]{Restrictions.isNotNull((String)"assetRecord"), Restrictions.isNotNull((String)"assetRecord.geolocation")});
        if (query.getLocation() != null) {
            criteriaBuilder.and(new Restriction[]{Restrictions.eq((String)"location", (Object)query.getLocation())});
        }
        if (!query.getNodeIds().isEmpty()) {
            criteriaBuilder.in("id", (Collection)query.getNodeIds());
        }
        return this.genericPersistenceAccessor.findMatching(criteriaBuilder.toCriteria());
    }

    private GeolocationInfo convert(OnmsNode node) {
        GeolocationInfo geolocationInfo = new GeolocationInfo();
        OnmsGeolocation onmsGeolocation = DefaultGeolocationService.geoLocation(node);
        if (onmsGeolocation != null) {
            geolocationInfo.setAddressInfo(DefaultGeolocationService.toAddressInfo(onmsGeolocation));
            if (onmsGeolocation.getLongitude() != null && onmsGeolocation.getLatitude() != null) {
                geolocationInfo.setCoordinates(new Coordinates(onmsGeolocation.getLongitude().doubleValue(), onmsGeolocation.getLatitude().doubleValue()));
            }
        }
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setNodeId(node.getId().intValue());
        nodeInfo.setNodeLabel(node.getLabel());
        nodeInfo.setNodeLabel(node.getLabel());
        nodeInfo.setForeignSource(node.getForeignSource());
        nodeInfo.setForeignId(node.getForeignId());
        nodeInfo.setLocation(node.getLocation().getLocationName());
        if (node.getAssetRecord() != null) {
            nodeInfo.setDescription(node.getAssetRecord().getDescription());
            nodeInfo.setMaintcontract(node.getAssetRecord().getMaintcontract());
        }
        if (node.getPrimaryInterface() != null) {
            nodeInfo.setIpAddress(InetAddressUtils.str((InetAddress)node.getPrimaryInterface().getIpAddress()));
        }
        nodeInfo.setCategories(node.getCategories().stream().map(OnmsCategory::getName).collect(Collectors.toList()));
        geolocationInfo.setNodeInfo(nodeInfo);
        return geolocationInfo;
    }

    private void applyStatus(GeolocationQuery query, List<GeolocationInfo> locations) {
        Set<Integer> nodeIds = locations.stream().map(l -> l.getNodeInfo().getNodeId()).collect(Collectors.toSet());
        if (!nodeIds.isEmpty()) {
            Status status = this.calculateStatus(query, nodeIds);
            for (GeolocationInfo info : locations) {
                OnmsSeverity severity = status.getSeverity(info.getNodeInfo().getNodeId());
                if (severity == null) {
                    severity = OnmsSeverity.NORMAL;
                }
                info.setSeverityInfo(new SeverityInfo(severity.getId(), severity.getLabel()));
                info.setAlarmUnackedCount(status.getUnacknowledgedAlarmCount(info.getNodeInfo().getNodeId()));
            }
        }
    }

    private Status calculateStatus(GeolocationQuery query, Set<Integer> nodeIds) {
        NodeStatusCalculatorConfig nodeStatusCalculatorConfig = new NodeStatusCalculatorConfig();
        nodeStatusCalculatorConfig.setIncludeAcknowledgedAlarms(query.isIncludeAcknowledgedAlarms());
        nodeStatusCalculatorConfig.setLocation(query.getLocation());
        if (query.getSeverity() != null) {
            OnmsSeverity severity = OnmsSeverity.get((int)query.getSeverity().getId());
            List severityFilter = Arrays.stream(OnmsSeverity.values()).filter(s -> s.isGreaterThanOrEqual(severity)).collect(Collectors.toList());
            nodeStatusCalculatorConfig.setSeverities(severityFilter);
        }
        if (query.getStatusCalculationStrategy() != null) {
            nodeStatusCalculatorConfig.setCalculationStrategy(NodeStatusCalculationStrategy.valueOf((String)query.getStatusCalculationStrategy().name()));
        }
        nodeStatusCalculatorConfig.setNodeIds(nodeIds);
        Status status = this.nodeStatusCalculator.calculateStatus(nodeStatusCalculatorConfig);
        return status;
    }

    private static OnmsGeolocation geoLocation(OnmsNode node) {
        if (node != null && node.getAssetRecord() != null && node.getAssetRecord().getGeolocation() != null) {
            return node.getAssetRecord().getGeolocation();
        }
        return null;
    }

    private static AddressInfo toAddressInfo(OnmsGeolocation input) {
        if (input != null) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setAddress1(input.getAddress1());
            addressInfo.setAddress2(input.getAddress2());
            addressInfo.setCity(input.getCity());
            addressInfo.setCountry(input.getCountry());
            addressInfo.setState(input.getState());
            addressInfo.setZip(input.getZip());
            return addressInfo;
        }
        return null;
    }
}

