/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.wsman.cxf;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.interceptor.transform.TransformInInterceptor;
import org.apache.cxf.interceptor.transform.TransformOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.cxf.transport.http.auth.DefaultBasicAuthSupplier;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.opennms.core.wsman.Identity;
import org.opennms.core.wsman.WSManClient;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.WSManVersion;
import org.opennms.core.wsman.cxf.EnumerationOperations;
import org.opennms.core.wsman.cxf.IdentifyOperations;
import org.opennms.core.wsman.cxf.IdentifyResponseWrapper;
import org.opennms.core.wsman.cxf.TransferOperations;
import org.opennms.core.wsman.cxf.TypeUtils;
import org.opennms.core.wsman.cxf.WSManHeaderInterceptor;
import org.opennms.core.wsman.exceptions.InvalidResourceURI;
import org.opennms.core.wsman.exceptions.SOAPFault;
import org.opennms.core.wsman.exceptions.UnauthorizedException;
import org.opennms.core.wsman.exceptions.WSManException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xmlsoap.schemas.ws._2004._09.enumeration.Enumerate;
import org.xmlsoap.schemas.ws._2004._09.enumeration.EnumerateResponse;
import org.xmlsoap.schemas.ws._2004._09.enumeration.EnumerationContextType;
import org.xmlsoap.schemas.ws._2004._09.enumeration.FilterType;
import org.xmlsoap.schemas.ws._2004._09.enumeration.Pull;
import org.xmlsoap.schemas.ws._2004._09.enumeration.PullResponse;
import org.xmlsoap.schemas.ws._2004._09.transfer.TransferElement;
import schemas.dmtf.org.wbem.wsman.v1.AttributableEmpty;
import schemas.dmtf.org.wbem.wsman.v1.AttributablePositiveInteger;
import schemas.dmtf.org.wbem.wsman.v1.IdentifyType;
import schemas.dmtf.org.wbem.wsman.v1.MaxEnvelopeSizeType;

public class CXFWSManClient
implements WSManClient {
    private static final Logger LOG = LoggerFactory.getLogger(CXFWSManClient.class);
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String MEDIA_TYPE_SOAP_UTF8 = "application/soap+xml;charset=UTF-8";
    private static final ObjectFactory WSA_OBJECT_FACTORY = new ObjectFactory();
    private static final schemas.dmtf.org.wbem.wsman.v1.ObjectFactory WSMAN_OBJECT_FACTORY = new schemas.dmtf.org.wbem.wsman.v1.ObjectFactory();
    private final WSManEndpoint m_endpoint;

    public CXFWSManClient(WSManEndpoint endpoint) {
        this.m_endpoint = Objects.requireNonNull(endpoint, "endpoint cannot be null");
    }

    public IdentifyOperations getIdentifier() {
        IdentifyOperations identifier = this.createProxyFor(IdentifyOperations.class, new HashMap<String, String>(), new HashMap<String, String>());
        Client cxfClient = ClientProxy.getClient((Object)identifier);
        WSManHeaderInterceptor interceptor = new WSManHeaderInterceptor("http://schemas.dmtf.org/wbem/wscim/1/*");
        cxfClient.getOutInterceptors().add(interceptor);
        return identifier;
    }

    public EnumerationOperations getEnumerator(String resourceUri) {
        HashMap<String, String> outTransformMap = new HashMap<String, String>();
        outTransformMap.put("{http://schemas.xmlsoap.org/ws/2004/09/enumeration}Filter", "{http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd}Filter");
        EnumerationOperations enumerator = this.createProxyFor(EnumerationOperations.class, outTransformMap, new HashMap<String, String>());
        Client cxfClient = ClientProxy.getClient((Object)enumerator);
        WSManHeaderInterceptor interceptor = new WSManHeaderInterceptor(resourceUri);
        cxfClient.getOutInterceptors().add(interceptor);
        return enumerator;
    }

    public TransferOperations getTransferer(String resourceUri, String elementType, Map<String, String> selectors) {
        HashMap<String, String> inTransformMap = new HashMap<String, String>();
        inTransformMap.put(String.format("{%s}%s", resourceUri, elementType), "{http://schemas.xmlsoap.org/ws/2004/09/transfer}TransferElement");
        TransferOperations transferer = this.createProxyFor(TransferOperations.class, new HashMap<String, String>(), inTransformMap);
        Client cxfClient = ClientProxy.getClient((Object)transferer);
        WSManHeaderInterceptor interceptor = new WSManHeaderInterceptor(resourceUri, selectors);
        cxfClient.getOutInterceptors().add(interceptor);
        return transferer;
    }

    public Identity identify() {
        IdentifyOperations identifier = this.getIdentifier();
        try {
            IdentifyResponseWrapper identifyResponseWrapper = new IdentifyResponseWrapper(identifier.identify(new IdentifyType()));
            return identifyResponseWrapper;
        }
        catch (RuntimeException e) {
            throw CXFWSManClient.wrapException(e);
        }
        finally {
            CXFWSManClient.destroy(identifier);
        }
    }

    private EnumerateResponse enumerate(String resourceUri, String dialect, String filter, boolean optimized) {
        JAXBElement<AttributablePositiveInteger> maxElements;
        Enumerate enumerate = new Enumerate();
        if (dialect != null && filter != null) {
            FilterType filterType = new FilterType();
            filterType.setDialect(dialect);
            filterType.getContent().add(filter);
            enumerate.setFilter(filterType);
        }
        if (optimized) {
            JAXBElement<AttributableEmpty> optimizeEnumeration = WSMAN_OBJECT_FACTORY.createOptimizeEnumeration(new AttributableEmpty());
            enumerate.getAny().add(optimizeEnumeration);
        }
        if (this.m_endpoint.getMaxEnvelopeSize() != null) {
            MaxEnvelopeSizeType maxEnvelopeSizeValue = WSMAN_OBJECT_FACTORY.createMaxEnvelopeSizeType();
            maxEnvelopeSizeValue.setValue(BigInteger.valueOf(this.m_endpoint.getMaxEnvelopeSize().intValue()));
            JAXBElement<MaxEnvelopeSizeType> maxEnvelopeSize = WSMAN_OBJECT_FACTORY.createMaxEnvelopeSize(maxEnvelopeSizeValue);
            enumerate.getAny().add(maxEnvelopeSize);
        }
        if (this.m_endpoint.getMaxElements() != null) {
            AttributablePositiveInteger maxElementsValue = new AttributablePositiveInteger();
            maxElementsValue.setValue(BigInteger.valueOf(this.m_endpoint.getMaxElements().intValue()));
            maxElements = WSMAN_OBJECT_FACTORY.createMaxElements(maxElementsValue);
            enumerate.getAny().add(maxElements);
        }
        EnumerationOperations enumerator = this.getEnumerator(resourceUri);
        try {
            maxElements = enumerator.enumerate(enumerate);
            return maxElements;
        }
        catch (RuntimeException e) {
            throw CXFWSManClient.wrapException(e);
        }
        finally {
            CXFWSManClient.destroy(enumerator);
        }
    }

    private String enumerateAndPull(String resourceUri, String dialect, String filter, List<Node> nodes, boolean recursive) {
        EnumerateResponse response = this.enumerate(resourceUri, dialect, filter, true);
        if (response == null) {
            throw new WSManException("Enumeration failed. See logs for details.");
        }
        String nextContextId = TypeUtils.getContextIdFrom(response);
        boolean endOfSequence = TypeUtils.getItemsFrom(response, nodes);
        if (!endOfSequence) {
            return this.pull(TypeUtils.getContextIdFrom(response), resourceUri, nodes, recursive);
        }
        return nextContextId;
    }

    public String enumerate(String resourceUri) {
        EnumerateResponse response = this.enumerate(resourceUri, null, null, false);
        if (response == null) {
            throw new WSManException("Enumeration failed. See logs for details.");
        }
        return TypeUtils.getContextIdFrom(response);
    }

    public String enumerateWithFilter(String resourceUri, String dialect, String filter) {
        EnumerateResponse response = this.enumerate(resourceUri, dialect, filter, false);
        if (response == null) {
            throw new WSManException("Enumeration failed. See logs for details.");
        }
        return TypeUtils.getContextIdFrom(response);
    }

    public String pull(String contextId, String resourceUri, List<Node> nodes, boolean recursive) {
        Pull pull = new Pull();
        EnumerationContextType enumContext = new EnumerationContextType();
        enumContext.getContent().add(contextId);
        pull.setEnumerationContext(enumContext);
        if (this.m_endpoint.getMaxElements() != null) {
            pull.setMaxElements(BigInteger.valueOf(this.m_endpoint.getMaxElements().intValue()));
        }
        EnumerationOperations enumerator = this.getEnumerator(resourceUri);
        PullResponse response = null;
        try {
            response = enumerator.pull(pull);
        }
        catch (RuntimeException e) {
            throw CXFWSManClient.wrapException(e);
        }
        finally {
            CXFWSManClient.destroy(enumerator);
        }
        if (response == null) {
            throw new WSManException(String.format("Pull failed for context id: %s. See logs for details.", contextId));
        }
        boolean endOfSequence = TypeUtils.getItemsFrom(response, nodes);
        String nextContextId = TypeUtils.getContextIdFrom(response);
        if (recursive && !endOfSequence) {
            return this.pull(nextContextId, resourceUri, nodes, recursive);
        }
        return nextContextId;
    }

    public String enumerateAndPull(String resourceUri, List<Node> nodes, boolean recursive) {
        return this.enumerateAndPull(resourceUri, null, null, nodes, recursive);
    }

    public String enumerateAndPullUsingFilter(String resourceUri, String dialect, String filter, List<Node> nodes, boolean recursive) {
        return this.enumerateAndPull(resourceUri, dialect, filter, nodes, recursive);
    }

    public Node get(String resourceUri, Map<String, String> selectors) {
        TransferElement transferElement;
        String elementType = TypeUtils.getElementTypeFromResourceUri(resourceUri);
        TransferOperations transferer = this.getTransferer(resourceUri, elementType, selectors);
        try {
            transferElement = transferer.get();
        }
        catch (RuntimeException e) {
            throw CXFWSManClient.wrapException(e);
        }
        finally {
            CXFWSManClient.destroy(transferer);
        }
        if (transferElement == null) {
            throw new WSManException("Get failed. See logs for details.");
        }
        return TypeUtils.transferElementToNode(transferElement, resourceUri, elementType);
    }

    private JaxWsProxyFactoryBean createFactoryFor(Class<?> clazz) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(clazz);
        factory.setAddress(this.m_endpoint.getUrl().toExternalForm());
        ExtensionManagerBus bus = new ExtensionManagerBus(null, null, Bus.class.getClassLoader());
        factory.setBus((Bus)bus);
        WSAddressingFeature feature = new WSAddressingFeature();
        feature.setResponses(WSAddressingFeature.AddressingResponses.ANONYMOUS);
        factory.getFeatures().add(feature);
        factory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
        return factory;
    }

    private <ProxyServiceType> ProxyServiceType createProxyFor(Class<ProxyServiceType> serviceClass, Map<String, String> outTransformMap, Map<String, String> inTransformMap) {
        Object proxyService = this.createFactoryFor(serviceClass).create(serviceClass);
        Client cxfClient = ClientProxy.getClient((Object)proxyService);
        Map requestContext = cxfClient.getRequestContext();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        nsMap.put("wsen", "http://schemas.xmlsoap.org/ws/2004/09/enumeration");
        nsMap.put("wsman", "http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd");
        nsMap.put("wsmid", "http://schemas.dmtf.org/wbem/wsman/identity/1/wsmanidentity.xsd");
        cxfClient.getRequestContext().put("soap.env.ns.map", nsMap);
        HTTPConduit http = (HTTPConduit)cxfClient.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setVersion("1.1");
        if (this.m_endpoint.getConnectionTimeout() != null) {
            httpClientPolicy.setConnectionTimeout((long)this.m_endpoint.getConnectionTimeout().intValue());
        }
        if (this.m_endpoint.getReceiveTimeout() != null) {
            httpClientPolicy.setReceiveTimeout((long)this.m_endpoint.getReceiveTimeout().intValue());
        }
        httpClientPolicy.setAllowChunking(false);
        http.setClient(httpClientPolicy);
        if (!this.m_endpoint.isStrictSSL()) {
            LOG.debug("Disabling strict SSL checking.");
            TrustManager[] simpleTrustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            TLSClientParameters tlsParams = new TLSClientParameters();
            tlsParams.setTrustManagers(simpleTrustManager);
            tlsParams.setDisableCNCheck(true);
            http.setTlsClientParameters(tlsParams);
        }
        if (this.m_endpoint.isGSSAuth()) {
            LOG.debug("Enabling GSS authentication.");
            http.getAuthorization().setAuthorizationType("Negotiate");
            http.getAuthorization().setAuthorization("WSManClient");
            http.getAuthorization().setUserName(this.m_endpoint.getUsername());
            http.getAuthorization().setPassword(this.m_endpoint.getPassword());
        } else if (this.m_endpoint.isBasicAuth()) {
            LOG.debug("Enabling basic authentication.");
            http.setAuthSupplier((HttpAuthSupplier)new DefaultBasicAuthSupplier());
            http.getAuthorization().setUserName(this.m_endpoint.getUsername());
            http.getAuthorization().setPassword(this.m_endpoint.getPassword());
            requestContext.put("javax.xml.ws.security.auth.username", this.m_endpoint.getUsername());
            requestContext.put("javax.xml.ws.security.auth.password", this.m_endpoint.getPassword());
        }
        requestContext.put("javax.xml.ws.addressing.context", this.createAddressingPropertiesMap());
        if (this.m_endpoint.getServerVersion() == WSManVersion.WSMAN_1_0) {
            outTransformMap.put("{http://www.w3.org/2005/08/addressing}*", "{http://schemas.xmlsoap.org/ws/2004/08/addressing}*");
        }
        if (!outTransformMap.isEmpty()) {
            TransformOutInterceptor transformOutInterceptor = new TransformOutInterceptor();
            transformOutInterceptor.setOutTransformElements(outTransformMap);
            cxfClient.getOutInterceptors().add(transformOutInterceptor);
        }
        if (!inTransformMap.isEmpty()) {
            TransformInInterceptor transformInInterceptor = new TransformInInterceptor();
            transformInInterceptor.setInTransformElements(inTransformMap);
            cxfClient.getInInterceptors().add(transformInInterceptor);
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put(CONTENT_TYPE_HEADER, Collections.singletonList(MEDIA_TYPE_SOAP_UTF8));
        requestContext.put(Message.PROTOCOL_HEADERS, headers);
        LoggingInInterceptor loggingInInterceptor = new LoggingInInterceptor();
        loggingInInterceptor.setPrettyLogging(true);
        cxfClient.getInInterceptors().add(loggingInInterceptor);
        LoggingOutInterceptor loggingOutInterceptor = new LoggingOutInterceptor();
        loggingOutInterceptor.setPrettyLogging(true);
        cxfClient.getOutInterceptors().add(loggingOutInterceptor);
        return (ProxyServiceType)proxyService;
    }

    private AddressingProperties createAddressingPropertiesMap() {
        AddressingProperties maps = new AddressingProperties();
        AttributedURIType address = WSA_OBJECT_FACTORY.createAttributedURIType();
        EndpointReferenceType ref = WSA_OBJECT_FACTORY.createEndpointReferenceType();
        address.setValue("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
        ref.setAddress(address);
        maps.setReplyTo(ref);
        maps.setFaultTo(ref);
        return maps;
    }

    private static RuntimeException wrapException(RuntimeException e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return e;
        }
        if (cause instanceof SoapFault) {
            SoapFault soapFault = (SoapFault)cause;
            QName subCode = soapFault.getSubCode();
            if (subCode != null && "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(soapFault.getSubCode().getNamespaceURI()) && "DestinationUnreachable".equals(soapFault.getSubCode().getLocalPart())) {
                return new InvalidResourceURI((Throwable)e);
            }
            throw new SOAPFault((Throwable)e);
        }
        if (cause instanceof HTTPException) {
            if (((HTTPException)cause).getResponseCode() == 401) {
                return new UnauthorizedException((Throwable)e);
            }
            throw new org.opennms.core.wsman.exceptions.HTTPException((Throwable)e);
        }
        return new WSManException((Throwable)e);
    }

    private static void destroy(Object proxy) {
        Client client = ClientProxy.getClient((Object)proxy);
        if (client != null) {
            try {
                Bus bus = client.getBus();
                if (bus != null) {
                    bus.shutdown(true);
                }
            }
            catch (Exception ex) {
                LOG.debug("Error shutting down CXF bus", (Throwable)ex);
            }
            try {
                client.destroy();
            }
            catch (Exception ex) {
                LOG.debug("Error destroying CXF client", (Throwable)ex);
            }
        }
    }
}

