/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;

public class IpV6 {
    public final Inet6Address ip_v6;

    public IpV6(ByteBuf buffer) {
        try {
            this.ip_v6 = (Inet6Address)Inet6Address.getByAddress(BufferUtils.bytes((ByteBuf)buffer, (int)16));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Inet6Address getAddress() {
        return this.ip_v6;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip_v6", (Object)this.ip_v6).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("address", this.ip_v6.getHostAddress());
        enr.getHostnameFor(this.ip_v6).ifPresent(hostname -> bsonWriter.writeString("hostname", hostname));
        bsonWriter.writeEndDocument();
    }

    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

