/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Array;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Mac;

public class HostAdapter {
    public final long ifIndex;
    public final Array<Mac> mac_address;

    public HostAdapter(ByteBuf buffer) throws InvalidPacketException {
        this.ifIndex = BufferUtils.uint32((ByteBuf)buffer);
        this.mac_address = new Array<Object>(buffer, Optional.empty(), Mac::new);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ifIndex", this.ifIndex).add("mac_address", this.mac_address).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("host_adapter");
        bsonWriter.writeInt64(this.ifIndex);
        bsonWriter.writeStartArray("mac_address");
        for (Mac mac : this.mac_address) {
            mac.writeBson(bsonWriter, enr);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeEndDocument();
    }
}

