/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.AsciiString;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.DurationUs;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Ieee80211Version;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Mac;

public class Extended80211Tx
implements FlowData {
    public final AsciiString ssid;
    public final Mac bssid;
    public final Ieee80211Version version;
    public final long transmissions;
    public final DurationUs packet_duration;
    public final DurationUs retrans_duration;
    public final long channel;
    public final UnsignedLong speed;
    public final long power;

    public Extended80211Tx(ByteBuf buffer) throws InvalidPacketException {
        this.ssid = new AsciiString(buffer);
        this.bssid = new Mac(buffer);
        this.version = Ieee80211Version.from(buffer);
        this.transmissions = BufferUtils.uint32((ByteBuf)buffer);
        this.packet_duration = new DurationUs(buffer);
        this.retrans_duration = new DurationUs(buffer);
        this.channel = BufferUtils.uint32((ByteBuf)buffer);
        this.speed = BufferUtils.uint64((ByteBuf)buffer);
        this.power = BufferUtils.uint32((ByteBuf)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ssid", (Object)this.ssid).add("bssid", (Object)this.bssid).add("version", (Object)this.version).add("transmissions", this.transmissions).add("packet_duration", (Object)this.packet_duration).add("retrans_duration", (Object)this.retrans_duration).add("channel", this.channel).add("speed", (Object)this.speed).add("power", this.power).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("ssid", this.ssid.value);
        bsonWriter.writeName("bssid");
        this.bssid.writeBson(bsonWriter, enr);
        bsonWriter.writeName("version");
        this.version.writeBson(bsonWriter, enr);
        bsonWriter.writeInt64("transmissions", this.transmissions);
        bsonWriter.writeName("packet_duration");
        this.packet_duration.writeBson(bsonWriter, enr);
        bsonWriter.writeName("retrans_duration");
        this.retrans_duration.writeBson(bsonWriter, enr);
        bsonWriter.writeInt64("channel", this.channel);
        bsonWriter.writeInt64("speed", this.speed.longValue());
        bsonWriter.writeInt64("power", this.power);
        bsonWriter.writeEndDocument();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

