/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Array;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CounterRecord;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SFlowDataSourceExpanded;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SampleData;

public class CountersSampleExpanded
implements SampleData {
    public final long sequence_number;
    public final SFlowDataSourceExpanded source_id;
    public final Array<CounterRecord> counters;

    public CountersSampleExpanded(ByteBuf buffer) throws InvalidPacketException {
        this.sequence_number = BufferUtils.uint32((ByteBuf)buffer);
        this.source_id = new SFlowDataSourceExpanded(buffer);
        this.counters = new Array<Object>(buffer, Optional.empty(), CounterRecord::new);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sequence_number", this.sequence_number).add("source_id", (Object)this.source_id).add("counters", this.counters).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("sequence_number", this.sequence_number);
        bsonWriter.writeName("source_id");
        this.source_id.writeBson(bsonWriter, enr);
        bsonWriter.writeStartDocument("counters");
        for (CounterRecord counterRecord : this.counters) {
            bsonWriter.writeName(counterRecord.dataFormat.toId());
            counterRecord.writeBson(bsonWriter, enr);
        }
        bsonWriter.writeEndDocument();
        bsonWriter.writeEndDocument();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

