/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp6;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.opennms.protocols.icmp6.ICMPv6EchoRequest;

public final class ICMPv6Socket {
    private static final String LIBRARY_NAME = "jicmp6";
    private static final String PROPERTY_NAME = "opennms.library.jicmp6";
    private static final String LOGGER_PROPERTY_NAME = "opennms.logger.jicmp6";
    private final FileDescriptor m_rawFd;

    private native void initSocket() throws IOException;

    private native void bindSocket(short var1) throws IOException;

    public ICMPv6Socket(short id) throws IOException {
        String property = System.getProperty(PROPERTY_NAME);
        boolean loaded = false;
        if (property != null) {
            try {
                this.log().debug("System property 'opennms.library.jicmp6' set to '" + property + ".  Attempting to load " + LIBRARY_NAME + " library from this location.");
                System.load(property);
                loaded = true;
            }
            catch (UnsatisfiedLinkError e) {
                this.log().info("Failed to load library " + property + ".");
            }
        }
        if (!loaded) {
            this.log().debug("Attempting to load library using System.loadLibrary(\"jicmp6\").");
            System.loadLibrary(LIBRARY_NAME);
        }
        this.log().info("Successfully loaded jicmp6 library.");
        this.m_rawFd = new FileDescriptor();
        this.initSocket();
        this.bindSocket(id);
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().startsWith("windows")) {
            ICMPv6EchoRequest p = new ICMPv6EchoRequest(id, 0, 1234L);
            byte[] buf = p.toBytes();
            DatagramPacket dgp = new DatagramPacket(buf, buf.length, InetAddress.getByName("::1"), 0);
            this.send(dgp);
        }
    }

    private Logger log() {
        try {
            if (System.getProperty(LOGGER_PROPERTY_NAME) != null) {
                return (Logger)Class.forName(System.getProperty(LOGGER_PROPERTY_NAME)).newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("[WARN] Unable to create jicmp6 logger from property opennms.logger.jicmp6 with value " + System.getProperty(LOGGER_PROPERTY_NAME) + ". " + e);
        }
        return new Logger(){

            @Override
            public void debug(String msg) {
                System.err.println("[DEBUG] " + msg);
            }

            @Override
            public void info(String msg) {
                System.err.println("[INFO] " + msg);
            }
        };
    }

    public final native void setTrafficClass(int var1) throws IOException;

    public final native void dontFragment() throws IOException;

    public final native DatagramPacket receive() throws IOException;

    public final native void send(DatagramPacket var1) throws IOException;

    public final native void close();

    public static interface Logger {
        public void debug(String var1);

        public void info(String var1);
    }
}

