/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.measurements.model.FilterParamDef;

@XmlRootElement(name="filter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FilterDef {
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlElement(name="parameter")
    private List<FilterParamDef> parameters = Lists.newArrayListWithCapacity((int)0);

    public FilterDef() {
    }

    public FilterDef(String name, String ... paramNamesAndValues) {
        if (paramNamesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Must have an even number of parameter names and values");
        }
        LinkedList parameters = Lists.newLinkedList();
        for (int i = 0; i < paramNamesAndValues.length; i += 2) {
            parameters.add(new FilterParamDef(paramNamesAndValues[i], paramNamesAndValues[i + 1]));
        }
        this.name = name;
        this.parameters = parameters;
    }

    public FilterDef(String name, List<FilterParamDef> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public List<FilterParamDef> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterDef other = (FilterDef)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.parameters});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Name", (Object)this.name).add("Parameters", this.parameters).toString();
    }
}

