/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.RowSortedTable;
import java.util.Map;
import org.opennms.netmgt.measurements.api.ExpressionEngine;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.FilterEngine;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.api.MeasurementsService;
import org.opennms.netmgt.measurements.api.QueryRequestValidator;
import org.opennms.netmgt.measurements.api.exceptions.FetchException;
import org.opennms.netmgt.measurements.api.exceptions.MeasurementException;
import org.opennms.netmgt.measurements.api.exceptions.ResourceNotFoundException;
import org.opennms.netmgt.measurements.api.exceptions.ValidationException;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.model.QueryResponse;
import org.opennms.netmgt.measurements.model.Source;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="measurementsService")
public class DefaultMeasurementsService
implements MeasurementsService {
    private final MeasurementFetchStrategy fetchStrategy;
    private final ExpressionEngine expressionEngine;
    private final FilterEngine filterEngine;
    private final QueryRequestValidator queryRequestValidator = new QueryRequestValidator();

    @Autowired
    public DefaultMeasurementsService(MeasurementFetchStrategy fetchStrategy, ExpressionEngine expressionEngine, FilterEngine filterEngine) {
        this.fetchStrategy = (MeasurementFetchStrategy)Preconditions.checkNotNull((Object)fetchStrategy);
        this.expressionEngine = (ExpressionEngine)Preconditions.checkNotNull((Object)expressionEngine);
        this.filterEngine = (FilterEngine)Preconditions.checkNotNull((Object)filterEngine);
    }

    @Override
    public QueryResponse query(QueryRequest request) throws MeasurementException {
        FetchResults results;
        this.validate(request);
        try {
            results = this.fetchStrategy.fetch(request.getStart(), request.getEnd(), request.getStep(), request.getMaxRows(), request.getHeartbeat(), request.getInterval(), request.getSources(), request.isRelaxed());
        }
        catch (Exception e) {
            throw new FetchException(e, "Fetch failed: {}", e.getMessage());
        }
        if (results == null) {
            throw new ResourceNotFoundException(request);
        }
        this.expressionEngine.applyExpressions(request, results);
        if (!request.getFilters().isEmpty()) {
            RowSortedTable<Long, String, Double> table = results.asRowSortedTable();
            this.filterEngine.filter(request.getFilters(), table);
            results = new FetchResults(table, results.getStep(), results.getConstants(), results.getMetadata());
        }
        Map<String, double[]> columns = results.getColumns();
        for (Source source : request.getSources()) {
            if (!source.getTransient()) continue;
            columns.remove(source.getLabel());
        }
        QueryResponse response = new QueryResponse();
        response.setStart(request.getStart());
        response.setEnd(request.getEnd());
        response.setStep(results.getStep());
        response.setTimestamps(results.getTimestamps());
        response.setColumns(results.getColumns());
        response.setConstants(results.getConstants());
        response.setMetadata(results.getMetadata());
        return response;
    }

    private void validate(QueryRequest request) throws ValidationException {
        this.queryRequestValidator.validate(request);
    }
}

