/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.events.sink.module;

import java.util.Objects;
import org.opennms.core.ipc.sink.api.AggregationPolicy;
import org.opennms.core.ipc.sink.api.AsyncPolicy;
import org.opennms.core.ipc.sink.xml.AbstractXmlSinkModule;
import org.opennms.netmgt.config.api.EventdConfig;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;

public class EventSinkModule
extends AbstractXmlSinkModule<Event, Log> {
    public static final String MODULE_ID = "Events";
    private final EventdConfig m_config;

    public EventSinkModule(EventdConfig config) {
        super(Log.class);
        this.m_config = config;
    }

    public String getId() {
        return MODULE_ID;
    }

    public int getNumConsumerThreads() {
        return this.m_config.getNumThreads();
    }

    public AggregationPolicy<Event, Log, Log> getAggregationPolicy() {
        return new AggregationPolicy<Event, Log, Log>(){

            public int getCompletionSize() {
                return EventSinkModule.this.m_config.getBatchSize();
            }

            public int getCompletionIntervalMs() {
                return EventSinkModule.this.m_config.getBatchIntervalMs();
            }

            public Object key(Event event) {
                return event;
            }

            public Log aggregate(Log eventLog, Event event) {
                if (eventLog == null) {
                    eventLog = new Log();
                    eventLog.addEvent(event);
                }
                eventLog.addEvent(event);
                return eventLog;
            }

            public Log build(Log accumulator) {
                return accumulator;
            }
        };
    }

    public AsyncPolicy getAsyncPolicy() {
        return new AsyncPolicy(){

            public int getQueueSize() {
                return EventSinkModule.this.m_config.getQueueSize();
            }

            public int getNumThreads() {
                return EventSinkModule.this.m_config.getNumThreads();
            }

            public boolean isBlockWhenFull() {
                return true;
            }
        };
    }

    public Event unmarshalSingleMessage(byte[] bytes) {
        Log log = (Log)this.unmarshal(bytes);
        return log.getEvents().getEvent(0);
    }

    public int hashCode() {
        return Objects.hash(MODULE_ID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == obj.getClass();
    }
}

