/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.ArrayList;
import org.opennms.core.network.IPAddressRange;
import org.opennms.core.network.IPAddressRangeSet;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.Range;

final class MergeableDefinition {
    private final Definition m_snmpConfigDef;
    private IPAddressRangeSet m_configRanges = new IPAddressRangeSet();

    public MergeableDefinition(Definition def) {
        this.m_snmpConfigDef = def;
        for (Range r : def.getRanges()) {
            this.m_configRanges.add(new IPAddressRange(r.getBegin(), r.getEnd()));
        }
        for (String s : def.getSpecifics()) {
            this.m_configRanges.add(new IPAddressRange(s));
        }
    }

    public IPAddressRangeSet getAddressRanges() {
        return this.m_configRanges;
    }

    protected void mergeMatchingAttributeDef(MergeableDefinition eventDefinition) {
        this.m_configRanges.addAll(eventDefinition.getAddressRanges());
        this.getConfigDef().setRanges(new ArrayList());
        this.getConfigDef().setSpecifics(new ArrayList());
        for (IPAddressRange range : this.m_configRanges) {
            if (range.isSingleton()) {
                this.getConfigDef().addSpecific(range.getBegin().toUserString());
                continue;
            }
            Range xmlRange = new Range();
            xmlRange.setBegin(range.getBegin().toUserString());
            xmlRange.setEnd(range.getEnd().toUserString());
            this.getConfigDef().addRange(xmlRange);
        }
    }

    public final Definition getConfigDef() {
        return this.m_snmpConfigDef;
    }

    private final <T> boolean areEquals(T object1, T object2) {
        return SnmpConfigManager.areEquals(object1, object2);
    }

    boolean matches(MergeableDefinition other) {
        return this.areEquals(this.getConfigDef().getReadCommunity(), other.getConfigDef().getReadCommunity()) && this.areEquals(this.getConfigDef().getPort(), other.getConfigDef().getPort()) && this.areEquals(this.getConfigDef().getRetry(), other.getConfigDef().getRetry()) && this.areEquals(this.getConfigDef().getTimeout(), other.getConfigDef().getTimeout()) && this.areEquals(this.getConfigDef().getVersion(), other.getConfigDef().getVersion()) && this.areEquals(this.getConfigDef().getMaxRepetitions(), other.getConfigDef().getMaxRepetitions()) && this.areEquals(this.getConfigDef().getMaxVarsPerPdu(), other.getConfigDef().getMaxVarsPerPdu()) && this.areEquals(this.getConfigDef().getAuthPassphrase(), other.getConfigDef().getAuthPassphrase()) && this.areEquals(this.getConfigDef().getAuthProtocol(), other.getConfigDef().getAuthProtocol()) && this.areEquals(this.getConfigDef().getContextEngineId(), other.getConfigDef().getContextEngineId()) && this.areEquals(this.getConfigDef().getContextName(), other.getConfigDef().getContextName()) && this.areEquals(this.getConfigDef().getEngineId(), other.getConfigDef().getEngineId()) && this.areEquals(this.getConfigDef().getEnterpriseId(), other.getConfigDef().getEnterpriseId()) && this.areEquals(this.getConfigDef().getMaxRequestSize(), other.getConfigDef().getMaxRequestSize()) && this.areEquals(this.getConfigDef().getPrivacyPassphrase(), other.getConfigDef().getPrivacyPassphrase()) && this.areEquals(this.getConfigDef().getPrivacyProtocol(), other.getConfigDef().getPrivacyProtocol()) && this.areEquals(this.getConfigDef().getProxyHost(), other.getConfigDef().getProxyHost()) && this.areEquals(this.getConfigDef().getSecurityLevel(), other.getConfigDef().getSecurityLevel()) && this.areEquals(this.getConfigDef().getSecurityName(), other.getConfigDef().getSecurityName()) && this.areEquals(this.getConfigDef().getWriteCommunity(), other.getConfigDef().getWriteCommunity()) && this.areEquals(this.getConfigDef().getTTL(), other.getConfigDef().getTTL()) && this.areEquals(this.getConfigDef().getProfileLabel(), other.getConfigDef().getProfileLabel());
    }

    boolean isEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    boolean isTrivial() {
        return this.isEmpty(this.getConfigDef().getReadCommunity()) && this.isEmpty(this.getConfigDef().getVersion()) && this.isEmpty(this.getConfigDef().getAuthPassphrase()) && this.isEmpty(this.getConfigDef().getAuthProtocol()) && this.isEmpty(this.getConfigDef().getContextEngineId()) && this.isEmpty(this.getConfigDef().getContextName()) && this.isEmpty(this.getConfigDef().getEngineId()) && this.isEmpty(this.getConfigDef().getEnterpriseId()) && this.isEmpty(this.getConfigDef().getPrivacyPassphrase()) && this.isEmpty(this.getConfigDef().getPrivacyProtocol()) && this.isEmpty(this.getConfigDef().getSecurityName()) && this.isEmpty(this.getConfigDef().getWriteCommunity()) && this.isEmpty(this.getConfigDef().getProxyHost()) && !this.getConfigDef().hasPort() && !this.getConfigDef().hasRetry() && !this.getConfigDef().hasTimeout() && !this.getConfigDef().hasMaxRepetitions() && !this.getConfigDef().hasMaxRequestSize() && !this.getConfigDef().hasMaxVarsPerPdu() && !this.getConfigDef().hasSecurityLevel() && !this.getConfigDef().hasTTL();
    }

    void removeRanges(MergeableDefinition eventDefinition) {
        this.m_configRanges.removeAll(eventDefinition.getAddressRanges());
        this.getConfigDef().setRanges(new ArrayList());
        this.getConfigDef().setSpecifics(new ArrayList());
        for (IPAddressRange r : this.m_configRanges) {
            if (r.isSingleton()) {
                this.getConfigDef().addSpecific(r.getBegin().toUserString());
                continue;
            }
            Range xmlRange = new Range();
            xmlRange.setBegin(r.getBegin().toUserString());
            xmlRange.setEnd(r.getEnd().toUserString());
            this.getConfigDef().addRange(xmlRange);
        }
    }

    boolean isEmpty() {
        return this.getConfigDef().getRanges().size() < 1 && this.getConfigDef().getSpecifics().size() < 1;
    }
}

