/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class DefaultPollerConfigDao
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPollerConfigDao.class);
    private Resource m_configResource;
    private PollerConfig m_pollerConfig;

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_configResource != null ? 1 : 0) != 0, (String)"property configResource must be set to a non-null value");
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() throws Exception {
        InputStream stream = null;
        File file = null;
        try {
            file = this.getConfigResource().getFile();
        }
        catch (IOException e) {
            LOG.info("Resource '{}' does not seem to have an underlying File object; using input stream", (Object)this.getConfigResource());
        }
        try {
            long lastModified;
            if (file != null) {
                lastModified = file.lastModified();
                stream = new FileInputStream(file);
                LOG.debug("loadConfig: creating new PollerConfigFactory from file path: {}", (Object)file.getPath());
            } else {
                lastModified = System.currentTimeMillis();
                stream = this.getConfigResource().getInputStream();
                LOG.debug("loadConfig: creating new PollerConfigFactory from input stream");
            }
            this.setPollerConfig(new PollerConfigFactory(lastModified, stream));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    private void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public Resource getConfigResource() {
        return this.m_configResource;
    }

    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }
}

