/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.heartbeat.consumer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.minion.heartbeat.common.HeartbeatModule;
import org.opennms.minion.heartbeat.common.MinionIdentityDTO;
import org.opennms.netmgt.dao.api.MinionDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.annotation.Transactional;

public class HeartbeatConsumer
implements MessageConsumer<MinionIdentityDTO, MinionIdentityDTO>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatConsumer.class);
    private static final boolean PROVISIONING = Boolean.valueOf(System.getProperty("opennms.minion.provisioning", "true"));
    private static final String PROVISIONING_FOREIGN_SOURCE_PATTERN = System.getProperty("opennms.minion.provisioning.foreignSourcePattern", "Minions");
    private static final Integer DEFAULT_QUEUE_SIZE = 500;
    private static final Integer queueSize = SystemProperties.getInteger((String)"opennms.minion.provisioning.queueSize", (Integer)DEFAULT_QUEUE_SIZE);
    private static final String MINION_INTERFACE = "127.0.0.1";
    private static String DEFAULT_SNMP_POLICY = "Minion-SNMP-Policy";
    private static String DEFAULT_SNMP_DETECTOR = "SNMP";
    private static final HeartbeatModule heartbeatModule = new HeartbeatModule();
    private final AtomicInteger numofRejected = new AtomicInteger(0);
    @Autowired
    private MinionDao minionDao;
    @Autowired
    private MessageConsumerManager messageConsumerManager;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository deployedForeignSourceRepository;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy eventProxy;
    @Autowired
    @Qualifier(value="eventSubscriptionService")
    private EventSubscriptionService eventSubscriptionService;
    @Autowired
    private NodeDao nodeDao;
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("minion-provision-handler").build();
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), this.threadFactory, new RejectedExecutionHandlerImpl());

    @Transactional
    public void handleMessage(MinionIdentityDTO minionHandle) {
        LOG.info("Received heartbeat for Minion with id: {} at location: {}", (Object)minionHandle.getId(), (Object)minionHandle.getLocation());
        OnmsMinion minion = this.minionDao.findById(minionHandle.getId());
        if (minion == null) {
            minion = new OnmsMinion();
            minion.setId(minionHandle.getId());
            minion.setLocation(null);
        }
        if (!(Objects.isNull(minionHandle.getVersion()) || !Objects.isNull(minion.getVersion()) && minion.getVersion().equals(minionHandle.getVersion()))) {
            minion.setVersion(minionHandle.getVersion());
        }
        String prevLocation = minion.getLocation();
        String nextLocation = minionHandle.getLocation();
        minion.setLocation(minionHandle.getLocation());
        if (minionHandle.getTimestamp() == null) {
            minion.setLastUpdated(new Date());
            LOG.info("Received heartbeat without a timestamp: {}", (Object)minionHandle);
        } else if (minion.getLastUpdated() == null) {
            minion.setLastUpdated(minionHandle.getTimestamp());
        } else if (minionHandle.getTimestamp().after(minion.getLastUpdated())) {
            minion.setLastUpdated(minionHandle.getTimestamp());
        } else {
            LOG.info("Ignoring stale timestamp from heartbeat: {}", (Object)minionHandle);
        }
        this.minionDao.saveOrUpdate((Object)minion);
        OnmsMinion onmsMinion = minion;
        this.executor.execute(() -> {
            this.provision(onmsMinion, prevLocation, nextLocation);
            if (prevLocation == null) {
                EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/monitoringSystemAdded", "OpenNMS.Minion.Heartbeat");
                eventBuilder.addParam("monitoringSystemType", "Minion");
                eventBuilder.addParam("monitoringSystemId", minionHandle.getId());
                eventBuilder.addParam("monitoringSystemLocation", nextLocation);
                try {
                    this.eventProxy.send(eventBuilder.getEvent());
                }
                catch (EventProxyException e) {
                    throw new DataAccessResourceFailureException("Unable to send event", (Throwable)e);
                }
            }
            if (!prevLocation.equals(nextLocation)) {
                EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/monitoringSystemLocationChanged", "OpenNMS.Minion.Heartbeat");
                eventBuilder.addParam("monitoringSystemType", "Minion");
                eventBuilder.addParam("monitoringSystemId", minionHandle.getId());
                eventBuilder.addParam("monitoringSystemPreviousLocation", prevLocation);
                eventBuilder.addParam("monitoringSystemLocation", nextLocation);
                try {
                    this.eventProxy.send(eventBuilder.getEvent());
                }
                catch (EventProxyException e) {
                    throw new DataAccessResourceFailureException("Unable to send event", (Throwable)e);
                }
            }
        });
    }

    private void provision(OnmsMinion minion, String prevLocation, String nextLocation) {
        RequisitionNode requisitionNode;
        ForeignSource foreignSource;
        Requisition nextRequisition;
        Requisition prevRequisition;
        if (!PROVISIONING) {
            return;
        }
        if (!this.eventSubscriptionService.hasEventListener("uei.opennms.org/internal/importer/reloadImport")) {
            return;
        }
        String prevForeignSource = String.format(PROVISIONING_FOREIGN_SOURCE_PATTERN, prevLocation);
        String nextForeignSource = String.format(PROVISIONING_FOREIGN_SOURCE_PATTERN, nextLocation);
        PluginConfig policy = new PluginConfig(DEFAULT_SNMP_POLICY, "org.opennms.netmgt.provision.persist.policies.MatchingSnmpInterfacePolicy");
        policy.addParameter("ifDescr", "~^docker.*$");
        policy.addParameter("action", "DO_NOT_PERSIST");
        policy.addParameter("matchBehavior", "ALL_PARAMETERS");
        PluginConfig detector = new PluginConfig(DEFAULT_SNMP_DETECTOR, "org.opennms.netmgt.provision.detector.snmp.SnmpDetector");
        String foreignId = minion.getLabel() != null ? minion.getLabel() : minion.getId();
        List nodes = this.nodeDao.findByForeignIdForLocation(foreignId, nextLocation);
        if (!nodes.isEmpty()) {
            ForeignSource foreignSource2 = this.deployedForeignSourceRepository.getForeignSource(prevForeignSource);
            if (foreignSource2.getPolicy(DEFAULT_SNMP_POLICY) == null || foreignSource2.getDetector(DEFAULT_SNMP_DETECTOR) == null) {
                foreignSource2.addPolicy(policy);
                foreignSource2.addDetector(detector);
                this.deployedForeignSourceRepository.save(foreignSource2);
            }
            return;
        }
        HashSet alteredForeignSources = Sets.newHashSet();
        if (!Objects.equals(prevForeignSource, nextForeignSource) && (prevRequisition = this.deployedForeignSourceRepository.getRequisition(prevForeignSource)) != null && prevRequisition.getNode(minion.getId()) != null) {
            prevRequisition.deleteNode(minion.getId());
            prevRequisition.updateDateStamp();
            this.deployedForeignSourceRepository.save(prevRequisition);
            this.deployedForeignSourceRepository.flush();
            alteredForeignSources.add(prevForeignSource);
        }
        if ((nextRequisition = this.deployedForeignSourceRepository.getRequisition(nextForeignSource)) != null && ((foreignSource = this.deployedForeignSourceRepository.getForeignSource(nextForeignSource)).getPolicy(DEFAULT_SNMP_POLICY) == null || foreignSource.getDetector(DEFAULT_SNMP_DETECTOR) == null)) {
            foreignSource.addPolicy(policy);
            foreignSource.addDetector(detector);
            this.deployedForeignSourceRepository.save(foreignSource);
            alteredForeignSources.add(nextForeignSource);
        }
        if (nextRequisition == null) {
            nextRequisition = new Requisition(nextForeignSource);
            nextRequisition.updateDateStamp();
            this.deployedForeignSourceRepository.save(nextRequisition);
            foreignSource = this.deployedForeignSourceRepository.getForeignSource(nextForeignSource);
            foreignSource.setDetectors(List.of(detector));
            foreignSource.setPolicies(List.of(policy));
            this.deployedForeignSourceRepository.save(foreignSource);
            alteredForeignSources.add(nextForeignSource);
        }
        if ((requisitionNode = nextRequisition.getNode(minion.getId())) == null) {
            requisitionInterface = new RequisitionInterface();
            requisitionInterface.setIpAddr(MINION_INTERFACE);
            requisitionInterface.setSnmpPrimary(PrimaryType.PRIMARY);
            HeartbeatConsumer.ensureServicesAreOnInterface(requisitionInterface);
            requisitionNode = new RequisitionNode();
            requisitionNode.setNodeLabel(minion.getId());
            requisitionNode.setForeignId(foreignId);
            requisitionNode.setLocation(minion.getLocation());
            requisitionNode.putInterface(requisitionInterface);
            nextRequisition.putNode(requisitionNode);
            nextRequisition.setDate(new Date());
            this.deployedForeignSourceRepository.save(nextRequisition);
            this.deployedForeignSourceRepository.flush();
            alteredForeignSources.add(nextForeignSource);
        } else {
            if (!prevLocation.equals(nextLocation)) {
                requisitionNode.setLocation(nextLocation);
            }
            if ((requisitionInterface = requisitionNode.getInterface(MINION_INTERFACE)) == null) {
                requisitionInterface = new RequisitionInterface();
                requisitionInterface.setIpAddr(MINION_INTERFACE);
                requisitionNode.putInterface(requisitionInterface);
            }
            if (HeartbeatConsumer.ensureServicesAreOnInterface(requisitionInterface)) {
                nextRequisition.setDate(new Date());
                this.deployedForeignSourceRepository.save(nextRequisition);
                this.deployedForeignSourceRepository.flush();
                alteredForeignSources.add(nextForeignSource);
            }
        }
        for (String alteredForeignSource : alteredForeignSources) {
            EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", "Web");
            eventBuilder.addParam("url", String.valueOf(this.deployedForeignSourceRepository.getRequisitionURL(alteredForeignSource)));
            try {
                this.eventProxy.send(eventBuilder.getEvent());
            }
            catch (EventProxyException e) {
                throw new DataAccessResourceFailureException("Unable to send event to import group " + alteredForeignSource, (Throwable)e);
            }
        }
    }

    private static boolean ensureServicesAreOnInterface(RequisitionInterface requisitionInterface) {
        ArrayList<RequisitionMonitoredService> minionServices = new ArrayList<RequisitionMonitoredService>();
        RequisitionMonitoredService heartbeatService = new RequisitionMonitoredService();
        heartbeatService.setServiceName("Minion-Heartbeat");
        minionServices.add(heartbeatService);
        RequisitionMonitoredService rpcService = new RequisitionMonitoredService();
        rpcService.setServiceName("Minion-RPC");
        minionServices.add(rpcService);
        RequisitionMonitoredService jmxService = new RequisitionMonitoredService();
        jmxService.setServiceName("JMX-Minion");
        minionServices.add(jmxService);
        boolean didAlterInterface = false;
        for (RequisitionMonitoredService svc : minionServices) {
            if (requisitionInterface.getMonitoredService(svc.getServiceName()) != null) continue;
            requisitionInterface.putMonitoredService(svc);
            didAlterInterface = true;
        }
        return didAlterInterface;
    }

    public void afterPropertiesSet() throws Exception {
        this.messageConsumerManager.registerConsumer((MessageConsumer)this);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public SinkModule<MinionIdentityDTO, MinionIdentityDTO> getModule() {
        return heartbeatModule;
    }

    @VisibleForTesting
    void setMinionDao(MinionDao minionDao) {
        this.minionDao = minionDao;
    }

    @VisibleForTesting
    void setEventProxy(EventProxy eventProxy) {
        this.eventProxy = eventProxy;
    }

    @VisibleForTesting
    void setDeployedForeignSourceRepository(ForeignSourceRepository deployedForeignSourceRepository) {
        this.deployedForeignSourceRepository = deployedForeignSourceRepository;
    }

    @VisibleForTesting
    ForeignSourceRepository getDeployedForeignSourceRepository() {
        return this.deployedForeignSourceRepository;
    }

    @VisibleForTesting
    public void setEventSubscriptionService(EventSubscriptionService eventSubscriptionService) {
        this.eventSubscriptionService = eventSubscriptionService;
    }

    @VisibleForTesting
    void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @VisibleForTesting
    AtomicInteger getNumofRejected() {
        return this.numofRejected;
    }

    private class RejectedExecutionHandlerImpl
    implements RejectedExecutionHandler {
        private RejectedExecutionHandlerImpl() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            LOG.debug("Provisioning queue for Minions with size {} is full , dropping heartbeat message ", (Object)threadPoolExecutor.getQueue().size());
            HeartbeatConsumer.this.numofRejected.incrementAndGet();
        }
    }
}

