/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.opennms.core.tracker.ResponseWithId;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.jni.JniPingRequestId;
import org.opennms.protocols.icmp.ICMPEchoPacket;

public final class JniPingResponse
implements ResponseWithId<JniPingRequestId>,
EchoPacket {
    private final InetAddress m_address;
    private final ICMPEchoPacket m_packet;

    public JniPingResponse(InetAddress addr, ICMPEchoPacket pkt) {
        this.m_packet = pkt;
        this.m_address = addr;
    }

    private ICMPEchoPacket getPacket() {
        return this.m_packet;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public JniPingRequestId getRequestId() {
        return new JniPingRequestId(this);
    }

    public boolean isEchoReply() {
        return this.getPacket().isEchoReply();
    }

    public int getIdentifier() {
        return this.getPacket().getIdentity();
    }

    public int getSequenceNumber() {
        return this.getPacket().getSequenceId();
    }

    public long getThreadId() {
        return this.getPacket().getTID();
    }

    public long getSentTimeNanos() {
        return this.getPacket().getSentTime();
    }

    public long getReceivedTimeNanos() {
        return this.getPacket().getReceivedTime();
    }

    public double elapsedTime(TimeUnit timeUnit) {
        double nanosPerUnit = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        return (double)(this.getPacket().getPingRTT() * 1000L) / nanosPerUnit;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('[');
        buf.append("Address = ").append(this.getAddress());
        buf.append(", ");
        buf.append("JniPingRequestId = ").append(this.getRequestId().toString());
        buf.append(']');
        return buf.toString();
    }
}

